/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.villages;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;

public class VillageStructures {
    public static void init() {
        if (PNCConfig.Common.Villagers.addMechanicHouse) {
            PlainsVillagePools.func_214744_a();
            SavannaVillagePools.func_214745_a();
            TaigaVillagePools.func_214806_a();
            DesertVillagePools.func_222739_a();
            SnowyVillagePools.func_214746_a();
            for (String biome : new String[]{"plains", "desert", "savanna", "taiga", "snowy"}) {
                VillageStructures.addToPool(new ResourceLocation("village/" + biome + "/houses"), PneumaticCraftUtils.RL("villages/mechanic_house_" + biome), 8);
            }
        }
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = JigsawManager.field_214891_a.func_214933_a(pool);
        List shuffled = old.func_214943_b(new Random());
        List newPieces = shuffled.stream().map(p -> new Pair(p, (Object)1)).collect(Collectors.toList());
        newPieces.add(new Pair((Object)new SingleJigsawPiece(toAdd.toString(), (List)ImmutableList.of(), JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(pool, old.func_214948_a(), newPieces, JigsawPattern.PlacementBehaviour.RIGID));
    }
}

