/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.client.gui.INeedTickUpdate;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegulatorTube;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientTickHandler {
    private static final ClientTickHandler INSTANCE = new ClientTickHandler();
    public static int TICKS;
    private final List<WeakReference<INeedTickUpdate>> updatedObjects = new ArrayList<WeakReference<INeedTickUpdate>>();

    public static ClientTickHandler instance() {
        return INSTANCE;
    }

    public void registerUpdatedObject(INeedTickUpdate stat) {
        this.updatedObjects.add(new WeakReference<INeedTickUpdate>(stat));
    }

    public void removeUpdatedObject(INeedTickUpdate stat) {
        for (int i = 0; i < this.updatedObjects.size(); ++i) {
            if (!stat.equals(this.updatedObjects.get(i).get())) continue;
            this.updatedObjects.remove(i);
            break;
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                    for (IArmorUpgradeClientHandler handler : ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot)) {
                        handler.reset();
                    }
                }
            }
            ++TICKS;
            ModuleRegulatorTube.hasTicked = false;
            ModuleRegulatorTube.inverted = false;
            ModuleRegulatorTube.inLine = true;
            for (int i = 0; i < this.updatedObjects.size(); ++i) {
                INeedTickUpdate updatedObject = (INeedTickUpdate)this.updatedObjects.get(i).get();
                if (updatedObject != null) {
                    updatedObject.update();
                    continue;
                }
                this.updatedObjects.remove(i);
                --i;
            }
        }
    }
}

