/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAmadronOffer;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.inventory.SlotUntouchable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronInvSync;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class GuiAmadron
extends GuiPneumaticContainerBase<ContainerAmadron, TileEntityBase> {
    private WidgetTextField searchBar;
    private WidgetVerticalScrollbar scrollbar;
    private int page;
    private final List<WidgetAmadronOffer> widgetOffers = new ArrayList<WidgetAmadronOffer>();
    private boolean needsRefreshing;
    private boolean hadProblem = false;
    private WidgetButtonExtended orderButton;
    private WidgetButtonExtended addTradeButton;
    private WidgetAnimatedStat customTradesTab;

    public GuiAmadron(ContainerAmadron container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, (ITextComponent)new StringTextComponent(""));
        this.field_146999_f = 176;
        this.field_147000_g = 202;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        TranslationTextComponent amadron = PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.title", new Object[0]);
        this.addLabel((ITextComponent)amadron, this.field_147003_i + this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)amadron) / 2, this.field_147009_r + 5, 0xFFFFFF);
        this.addLabel((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.search", new Object[0]), this.field_147003_i + 76 - this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"pneumaticcraft.gui.search", (Object[])new Object[0])), this.field_147009_r + 41, 0xFFFFFF);
        this.addInfoTab(I18n.func_135052_a((String)"gui.tooltip.item.pneumaticcraft.amadron_tablet", (Object[])new Object[0]));
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.ghostSlotInteraction.title", new Object[0]), Textures.GUI_MOUSE_LOCATION, -16733441, true).setText("pneumaticcraft.gui.tab.info.ghostSlotInteraction");
        this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.disclaimer.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151099_bA), -16776961, true).setText("pneumaticcraft.gui.tab.amadron.disclaimer");
        this.customTradesTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.amadron.customTrades", new Object[0]), new ItemStack((IItemProvider)Items.field_151045_i), -3117056, false);
        this.customTradesTab.addPadding(6, 10);
        this.field_230712_o_.getClass();
        this.searchBar = new WidgetTextField(this.field_230712_o_, this.field_147003_i + 79, this.field_147009_r + 40, 73, 9);
        this.searchBar.func_146195_b(true);
        this.searchBar.func_212954_a(s -> this.sendDelayed(8));
        this.func_230480_a_((Widget)this.searchBar);
        this.func_231035_a_((IGuiEventListener)this.searchBar);
        this.scrollbar = new WidgetVerticalScrollbar(this.field_147003_i + 156, this.field_147009_r + 54, 142).setStates(1).setListening(true);
        this.func_230480_a_(this.scrollbar);
        List<ITextComponent> tooltip = PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)"pneumaticcraft.gui.amadron.button.order.tooltip", (Object[])new Object[0]));
        this.orderButton = new WidgetButtonExtended(this.field_147003_i + 52, this.field_147009_r + 16, 72, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.order", new Object[0])).setTooltipText(tooltip).withTag("order");
        this.func_230480_a_((Widget)this.orderButton);
        this.addTradeButton = new WidgetButtonExtended(16, 26, 20, 20).setRenderStacks(new ItemStack((IItemProvider)Items.field_151166_bC)).withTag("addPlayerTrade");
        tooltip = new ArrayList<ITextComponent>();
        tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.amadron.button.addTrade", new Object[0]));
        tooltip.addAll(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)"pneumaticcraft.gui.amadron.button.addTrade.tooltip", (Object[])new Object[0])));
        this.addTradeButton.setTooltipText(tooltip);
        this.customTradesTab.addSubWidget((Widget)this.addTradeButton);
        this.needsRefreshing = true;
    }

    @Override
    protected void doDelayedAction() {
        this.needsRefreshing = true;
        this.scrollbar.setCurrentState(0);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.scrollbar.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    protected int getBackgroundTint() {
        return 429612;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AMADRON;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.needsRefreshing || this.page != this.scrollbar.getState()) {
            this.setPage(this.scrollbar.getState());
        }
        for (WidgetAmadronOffer offer : this.widgetOffers) {
            offer.setCanBuy(((ContainerAmadron)this.field_147002_h).buyableOffers[((ContainerAmadron)this.field_147002_h).activeOffers.indexOf(offer.getOffer())]);
            offer.setShoppingAmount(((ContainerAmadron)this.field_147002_h).getShoppingCartAmount(offer.getOffer()));
        }
        if (!this.hadProblem && ((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            this.problemTab.openStat();
        }
        this.hadProblem = ((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS;
        this.orderButton.field_230693_o_ = !((ContainerAmadron)this.field_147002_h).isBasketEmpty();
        this.addTradeButton.field_230693_o_ = ((ContainerAmadron)this.field_147002_h).currentOffers < ((ContainerAmadron)this.field_147002_h).maxOffers;
        ArrayList<String> text = new ArrayList<String>();
        text.add(I18n.func_135052_a((String)"pneumaticcraft.gui.amadron.button.addTrade.tooltip.offerCount", (Object[])new Object[]{((ContainerAmadron)this.field_147002_h).currentOffers, ((ContainerAmadron)this.field_147002_h).maxOffers == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(((ContainerAmadron)this.field_147002_h).maxOffers)}));
        IntStream.range(0, 3).forEach(i -> text.add(" "));
        this.customTradesTab.setText(text);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
        return this.searchBar.func_231046_a_(keyCode, scanCode, modifiers) || this.searchBar.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void setPage(int page) {
        this.page = page;
        this.updateVisibleOffers();
    }

    private void updateVisibleOffers() {
        int i;
        this.needsRefreshing = false;
        int invSize = 8;
        ((ContainerAmadron)this.field_147002_h).clearStacks();
        ArrayList<Pair> visibleOffers = new ArrayList<Pair>();
        int skippedOffers = 0;
        int applicableOffers = 0;
        for (i = 0; i < ((ContainerAmadron)this.field_147002_h).activeOffers.size(); ++i) {
            AmadronOffer offer = ((ContainerAmadron)this.field_147002_h).activeOffers.get(i);
            if (!offer.passesQuery(this.searchBar.func_146179_b())) continue;
            ++applicableOffers;
            if (skippedOffers < this.page * invSize) {
                ++skippedOffers;
                continue;
            }
            if (visibleOffers.size() >= invSize) continue;
            visibleOffers.add(Pair.of((Object)i, (Object)offer));
        }
        this.scrollbar.setStates(Math.max(1, (applicableOffers + invSize - 1) / invSize - 1));
        this.field_230710_m_.removeAll(this.widgetOffers);
        this.field_230705_e_.removeAll(this.widgetOffers);
        for (i = 0; i < visibleOffers.size(); ++i) {
            int offerId = (Integer)((Pair)visibleOffers.get(i)).getLeft();
            AmadronOffer offer = (AmadronOffer)((Pair)visibleOffers.get(i)).getRight();
            if (!offer.getInput().getItem().func_190926_b()) {
                ((ContainerAmadron)this.field_147002_h).func_75139_a(i * 2).func_75215_d(offer.getInput().getItem());
                ((SlotUntouchable)((ContainerAmadron)this.field_147002_h).func_75139_a(i * 2)).setEnabled(true);
            }
            if (!offer.getOutput().getItem().func_190926_b()) {
                ((ContainerAmadron)this.field_147002_h).func_75139_a(i * 2 + 1).func_75215_d(offer.getOutput().getItem());
                ((SlotUntouchable)((ContainerAmadron)this.field_147002_h).func_75139_a(i * 2 + 1)).setEnabled(true);
            }
            WidgetAmadronOfferAdjustable widget = new WidgetAmadronOfferAdjustable(offerId, this.field_147003_i + 6 + 73 * (i % 2), this.field_147009_r + 55 + 35 * (i / 2), offer);
            this.func_230480_a_(widget);
            this.widgetOffers.add(widget);
        }
        for (i = visibleOffers.size() * 2; i < ((ContainerAmadron)this.field_147002_h).field_75151_b.size(); ++i) {
            ((SlotUntouchable)((ContainerAmadron)this.field_147002_h).func_75139_a(i)).setEnabled(false);
        }
        NetworkHandler.sendToServer(new PacketAmadronInvSync((List<ItemStack>)((ContainerAmadron)this.field_147002_h).func_75138_a()));
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((ContainerAmadron)this.field_147002_h).problemState != ContainerAmadron.EnumProblemState.NO_PROBLEMS) {
            curInfo.add(((ContainerAmadron)this.field_147002_h).problemState.getTranslationKey());
        }
    }

    static class WidgetAmadronOfferAdjustable
    extends WidgetAmadronOffer {
        private final int offerId;

        WidgetAmadronOfferAdjustable(int offerId, int x, int y, AmadronOffer offer) {
            super(x, y, offer);
            this.offerId = offerId;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            if (this.func_230992_c_(mouseX, mouseY)) {
                NetworkHandler.sendToServer(new PacketAmadronOrderUpdate(this.offerId, mouseButton, Screen.func_231173_s_()));
                return true;
            }
            return false;
        }
    }
}

