/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerAssemblyController;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiAssemblyController
extends GuiPneumaticContainerBase<ContainerAssemblyController, TileEntityAssemblyController> {
    private WidgetAnimatedStat statusStat;

    public GuiAssemblyController(ContainerAssemblyController container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()), -22016, false);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        this.field_230712_o_.func_238421_b_(matrixStack, "Prog.", 70.0f, 24.0f, 0x404040);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ASSEMBLY_CONTROLLER;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        EnumSet<AssemblyProgram.EnumMachine> foundMachines = EnumSet.of(AssemblyProgram.EnumMachine.CONTROLLER);
        for (IAssemblyMachine machine : ((TileEntityAssemblyController)this.te).findMachines(AssemblyProgram.EnumMachine.values().length)) {
            foundMachines.add(machine.getAssemblyType());
        }
        for (AssemblyProgram.EnumMachine m : AssemblyProgram.EnumMachine.values()) {
            if (m == AssemblyProgram.EnumMachine.CONTROLLER) continue;
            String s = foundMachines.contains((Object)m) ? TextFormatting.DARK_GREEN + "\u2714 " : TextFormatting.RED + "\u2717 ";
            text.add(s + TextFormatting.BLACK + " " + I18n.func_135052_a((String)m.getTranslationKey(), (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (((TileEntityAssemblyController)this.te).curProgram == null) {
            textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.assembly_controller.no_program", (Object[])new Object[0])));
        } else if (((TileEntityAssemblyController)this.te).isMachineDuplicate) {
            String s = ((TileEntityAssemblyController)this.te).duplicateMachine == null ? "<???>" : I18n.func_135052_a((String)((TileEntityAssemblyController)this.te).duplicateMachine.getTranslationKey(), (Object[])new Object[0]);
            textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.assembly_controller.duplicateMachine", (Object[])new Object[]{s})));
        } else if (((TileEntityAssemblyController)this.te).isMachineMissing) {
            String s = ((TileEntityAssemblyController)this.te).missingMachine == null ? "<???>" : I18n.func_135052_a((String)((TileEntityAssemblyController)this.te).missingMachine.getTranslationKey(), (Object[])new Object[0]);
            textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.assembly_controller.missingMachine", (Object[])new Object[]{s})));
        } else {
            ((TileEntityAssemblyController)this.te).curProgram.addProgramProblem(textList);
        }
    }
}

