/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStation;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiChargingStation
extends GuiPneumaticContainerBase<ContainerChargingStation, TileEntityChargingStation> {
    private WidgetButtonExtended guiSelectButton;
    private float renderAirProgress;

    public GuiChargingStation(ContainerChargingStation container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 182;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.guiSelectButton = new WidgetButtonExtended(xStart + 90, yStart + 22, 18, 19, "").withTag("open_upgrades");
        this.guiSelectButton.setRenderedIcon(Textures.GUI_UPGRADES_LOCATION);
        this.guiSelectButton.field_230694_p_ = false;
        this.func_230480_a_((Widget)this.guiSelectButton);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_CHARGING_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float opacity, int x, int y) {
        super.func_230450_a_(matrixStack, opacity, x, y);
        this.renderAir(matrixStack);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ItemStack stack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        this.guiSelectButton.field_230694_p_ = stack.func_77973_b() instanceof IChargeableContainerProvider;
        if (this.guiSelectButton.field_230694_p_) {
            this.guiSelectButton.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.charging_station.manageUpgrades", stack.func_200301_q()));
        }
        if (((TileEntityChargingStation)this.te).charging) {
            this.renderAirProgress += 0.001f * Math.min(25.0f, ((TileEntityChargingStation)this.te).getSpeedMultiplierFromUpgrades());
            if (this.renderAirProgress > 1.0f) {
                this.renderAirProgress = 0.0f;
            }
        } else if (((TileEntityChargingStation)this.te).discharging) {
            this.renderAirProgress -= 0.001f * Math.min(25.0f, ((TileEntityChargingStation)this.te).getSpeedMultiplierFromUpgrades());
            if (this.renderAirProgress < 0.0f) {
                this.renderAirProgress = 1.0f;
            }
        }
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4 + 10, yStart + this.field_147000_g / 4 + 10);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        if (((TileEntityChargingStation)this.te).charging || ((TileEntityChargingStation)this.te).discharging) {
            String key = ((TileEntityChargingStation)this.te).charging ? "pneumaticcraft.gui.tooltip.charging" : "pneumaticcraft.gui.tooltip.discharging";
            String amount = PneumaticCraftUtils.roundNumberTo(10.0f * ((TileEntityChargingStation)this.te).getSpeedMultiplierFromUpgrades(), 1);
            pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)key, (Object[])new Object[]{amount}));
        } else {
            pressureStatText.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.charging", (Object[])new Object[]{0}));
        }
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        ItemStack chargeStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        if (!chargeStack.func_190926_b() && !chargeStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).isPresent()) {
            textList.addAll(PneumaticCraftUtils.splitString("\u00a70Non-pneumatic item in the charge slot!?", 45));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        ItemStack chargeStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        if (chargeStack.func_190926_b()) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.charging_station.no_item", (Object[])new Object[0]));
        } else {
            chargeStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
                String name = chargeStack.func_200301_q().getString();
                if (h.getPressure() > ((TileEntityChargingStation)this.te).getPressure() + 0.01f && h.getPressure() <= 0.0f) {
                    curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.charging_station.item_empty", (Object[])new Object[]{name})));
                } else if (h.getPressure() < ((TileEntityChargingStation)this.te).getPressure() - 0.01f && h.getPressure() >= h.maxPressure()) {
                    curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.charging_station.item_full", (Object[])new Object[]{name})));
                } else if (!((TileEntityChargingStation)this.te).charging && !((TileEntityChargingStation)this.te).discharging) {
                    curInfo.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.charging_station.pressure_equal", (Object[])new Object[]{name})));
                }
            });
        }
    }

    private void renderAir(MatrixStack matrixStack) {
        RenderSystem.disableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.lineWidth((float)2.0f);
        int particles = 10;
        for (int i = 0; i < particles; ++i) {
            this.renderAirParticle(matrixStack, this.renderAirProgress % (1.0f / (float)particles) + (float)i / (float)particles);
        }
        RenderSystem.enableTexture();
    }

    private void renderAirParticle(MatrixStack matrixStack, float particleProgress) {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        float x = (float)xStart + 117.0f;
        float y = (float)yStart + 56.5f;
        if (particleProgress < 0.5f) {
            y += particleProgress * 56.0f;
        } else if (particleProgress < 0.7f) {
            y += 28.0f;
            x -= (particleProgress - 0.5f) * 90.0f;
        } else {
            y += 28.0f;
            x -= 18.0f;
            y -= (particleProgress - 0.7f) * 70.0f;
        }
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GL11.glPointSize((float)5.0f);
        wr.func_181668_a(0, DefaultVertexFormats.field_181705_e);
        wr.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

