/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;

public abstract class GuiChargingUpgradeManager
extends GuiPneumaticContainerBase<ContainerChargingStationUpgradeManager, TileEntityChargingStation> {
    protected final ItemStack itemStack;
    private Button guiBackButton;

    GuiChargingUpgradeManager(ContainerChargingStationUpgradeManager container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.itemStack = ((TileEntityChargingStation)this.te).getPrimaryInventory().getStackInSlot(0);
        this.field_147000_g = 182;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_CHARGING_UPGRADE_MANAGER;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.guiBackButton = new WidgetButtonExtended(xStart + 8, yStart + 5, 16, 16, "\u25c0").withTag("close_upgrades");
        this.func_230480_a_((Widget)this.guiBackButton);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        int upgrades = UpgradableItemUtils.getUpgrades(this.itemStack, EnumUpgrade.VOLUME);
        int volume = ApplicableUpgradesDB.getInstance().getUpgradedVolume(this.getDefaultVolume(), upgrades);
        float curPressure = ((TileEntityChargingStation)this.te).chargingItemPressure;
        String col = TextFormatting.BLACK.toString();
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityChargingStation)this.te).chargingItemPressure, 2)}));
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.air", (Object[])new Object[]{String.format("%,d", Math.round(curPressure * (float)volume))}));
        pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.baseVolume", (Object[])new Object[]{String.format("%,d", this.getDefaultVolume())}));
        if (volume > this.getDefaultVolume()) {
            pressureStatText.add(col + "\u25b6" + " " + upgrades + " x " + EnumUpgrade.VOLUME.getItemStack().func_200301_q().getString());
            pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.effectiveVolume", (Object[])new Object[]{String.format("%,d", volume)}));
        }
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected abstract int getDefaultVolume();

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238422_b_(matrixStack, this.itemStack.func_200301_q().func_241878_f(), (float)(this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.itemStack.func_200301_q())) / 2.0f, 5.0f, 0x404040);
        int gaugeX = this.field_146999_f * 3 / 4 + 10;
        int gaugeY = this.field_147000_g / 4 + 10;
        this.itemStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.field_230712_o_, 0.0f, h.maxPressure(), h.maxPressure(), 0.0f, ((TileEntityChargingStation)this.te).chargingItemPressure, gaugeX, gaugeY));
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
        GuiUtils.renderItemStack(matrixStack, this.itemStack, 3, 22);
        matrixStack.func_227865_b_();
    }

    @Override
    protected PointXY getGaugeLocation() {
        return null;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.guiBackButton.func_230930_b_();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    void addUpgradeTabs(Item item, String ... what) {
        boolean leftSided = true;
        for (EnumUpgrade upgrade : EnumUpgrade.values()) {
            int max;
            if (!upgrade.isDepLoaded() || (max = ApplicableUpgradesDB.getInstance().getMaxUpgrades(item, upgrade)) <= 0) continue;
            ItemStack upgradeStack = upgrade.getItemStack();
            ArrayList<String> text = new ArrayList<String>();
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.upgrades.max", (Object[])new Object[]{max}));
            for (String w : what) {
                String key = "pneumaticcraft.gui.tab.info.item." + w + "." + upgrade.getName() + "Upgrade";
                if (!I18n.func_188566_a((String)key)) continue;
                text.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)key, (Object[])new Object[0]), 30));
                break;
            }
            this.addAnimatedStat(upgradeStack.func_200301_q(), upgradeStack, -10460929, leftSided).setTextWithoutCuttingString(text);
            leftSided = !leftSided;
        }
    }
}

