/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerElevator;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiElevator
extends GuiPneumaticContainerBase<ContainerElevator, TileEntityElevatorBase> {
    private WidgetAnimatedStat statusStat;
    private WidgetTextField floorNameField;
    private WidgetLabel noFloorsLabel;
    private WidgetLabel floorNumberLabel;
    private WidgetButtonExtended cycleDown;
    private WidgetButtonExtended cycleUp;
    private int currentEditedFloor;

    public GuiElevator(ContainerElevator container, PlayerInventory inventoryPlayer, ITextComponent displayName) {
        super(container, inventoryPlayer, displayName);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status", new Object[0]), new ItemStack((IItemProvider)ModBlocks.ELEVATOR_BASE.get()), -22016, false);
        WidgetAnimatedStat floorNameStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.floorNames", new Object[0]), new ItemStack((IItemProvider)ModBlocks.ELEVATOR_CALLER.get()), -16755456, false);
        floorNameStat.addPadding(7, 40);
        this.floorNameField = new WidgetTextField(this.field_230712_o_, 6, 60, 160, 20);
        this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
        this.floorNameField.func_212954_a(this::updateFloor);
        floorNameStat.addSubWidget((Widget)this.floorNameField);
        this.noFloorsLabel = new WidgetLabel(5, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.noCallers", new Object[0])).setColor(-1);
        floorNameStat.addSubWidget(this.noFloorsLabel);
        this.floorNumberLabel = new WidgetLabel(85, 40, StringTextComponent.field_240750_d_).setAlignment(WidgetLabel.Alignment.CENTRE).setColor(-1);
        floorNameStat.addSubWidget(this.floorNumberLabel);
        this.cycleDown = new WidgetButtonExtended(5, 35, 20, 20, "\u27f5", button -> this.cycleFloor(-1));
        floorNameStat.addSubWidget((Widget)this.cycleDown);
        this.cycleUp = new WidgetButtonExtended(145, 35, 20, 20, "\u27f6", button -> this.cycleFloor(1));
        floorNameStat.addSubWidget((Widget)this.cycleUp);
    }

    private void cycleFloor(int dir) {
        if (((TileEntityElevatorBase)this.te).floorHeights.length > 0) {
            this.currentEditedFloor += dir;
            if (this.currentEditedFloor >= ((TileEntityElevatorBase)this.te).floorHeights.length) {
                this.currentEditedFloor = 0;
            } else if (this.currentEditedFloor < 0) {
                this.currentEditedFloor = ((TileEntityElevatorBase)this.te).floorHeights.length - 1;
            }
            this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
            this.floorNameField.func_146195_b(true);
        }
    }

    private void updateFloor(String floorName) {
        ((TileEntityElevatorBase)this.te).setFloorName(this.currentEditedFloor, floorName);
        this.sendDelayed(5);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, this.currentEditedFloor));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ELEVATOR;
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float opacity, int x, int y) {
        super.func_230450_a_(matrixStack, opacity, x, y);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.statusStat.setText(this.getStatusText());
        this.cycleUp.field_230693_o_ = ((TileEntityElevatorBase)this.te).floorHeights.length > 0;
        this.cycleDown.field_230693_o_ = this.cycleUp.field_230693_o_;
        this.noFloorsLabel.field_230694_p_ = ((TileEntityElevatorBase)this.te).floorHeights.length == 0;
        this.floorNumberLabel.field_230694_p_ = ((TileEntityElevatorBase)this.te).floorHeights.length > 0;
        this.floorNameField.field_230693_o_ = ((TileEntityElevatorBase)this.te).floorHeights.length > 0;
        this.floorNumberLabel.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.elevator.floorNumber", this.currentEditedFloor + 1, ((TileEntityElevatorBase)this.te).floorHeights.length));
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.elevator.extension", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).extension, 1)}));
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.info.elevator.maxExtension", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).getMaxElevatorHeight(), 1)}));
        return text;
    }

    @Override
    protected void addWarnings(List<String> textList) {
        super.addWarnings(textList);
        if (((TileEntityElevatorBase)this.te).getMaxElevatorHeight() == ((TileEntityElevatorBase)this.te).extension) {
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.elevator.fully_extended", (Object[])new Object[0]));
        }
    }
}

