/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerEtchingTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityEtchingTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiEtchingTank
extends GuiPneumaticContainerBase<ContainerEtchingTank, TileEntityEtchingTank> {
    private WidgetTemperature tempWidget;

    public GuiEtchingTank(ContainerEtchingTank container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 206;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new WidgetTank(this.field_147003_i + 149, this.field_147009_r + 18, ((TileEntityEtchingTank)this.te).getAcidTank()));
        this.tempWidget = new WidgetTemperature(this.field_147003_i + 134, this.field_147009_r + 18, TemperatureRange.of(273, 773), 323, 50){

            @Override
            public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
                super.addTooltip(mouseX, mouseY, curTip, shift);
                int interval = ((TileEntityEtchingTank)GuiEtchingTank.this.te).getTickInterval();
                int processTimeSecs = interval * 5;
                curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.etching_tank.process_time", processTimeSecs).func_240699_a_(TextFormatting.GREEN));
                if (this.getTemperature() > 323) {
                    float usage = (float)(30 - interval) / (5.0f * (float)interval);
                    curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.etching_tank.acid_usage", PneumaticCraftUtils.roundNumberTo(usage, 2)).func_240699_a_(TextFormatting.YELLOW));
                }
            }
        };
        this.func_230480_a_(this.tempWidget);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ((TileEntityEtchingTank)this.te).getHeatCap(null).ifPresent(l -> this.tempWidget.setTemperature(l.getTemperatureAsInt()));
        this.tempWidget.autoScaleForTemperature();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ETCHING_TANK;
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (((TileEntityEtchingTank)this.te).isOutputFull()) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.etching_tank.output_full", (Object[])new Object[0]));
        }
        if (((TileEntityEtchingTank)this.te).isFailedOutputFull()) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.etching_tank.failed_full", (Object[])new Object[0]));
        }
        if (((TileEntityEtchingTank)this.te).getAcidTank().getFluid().isEmpty()) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.etching_tank.no_acid", (Object[])new Object[0]));
        }
    }
}

