/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorMainScreen;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerItemSearcher;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class GuiItemSearcher
extends ContainerScreen<ContainerItemSearcher> {
    private static final ResourceLocation GUI_TEXTURE = Textures.GUI_ITEM_SEARCHER;
    private static final ResourceLocation SCROLL_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static List<SearchEntry> cachedSearchEntries;
    private final ItemStackHandler inventory = new ItemStackHandler(49);
    private final Screen parentScreen;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private TextFieldWidget searchField;
    private boolean firstRun = true;

    public GuiItemSearcher(ContainerItemSearcher container, PlayerInventory playerInventory, ITextComponent displayString) {
        super((Container)container, playerInventory, displayString);
        this.field_230711_n_ = true;
        this.field_147000_g = 176;
        this.parentScreen = Minecraft.func_71410_x().field_71462_r;
        container.init(this);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    @Nonnull
    public ItemStack getSearchStack() {
        return this.inventory.getStackInSlot(48);
    }

    public void setSearchStack(@Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(48, stack);
    }

    protected void func_184098_a(Slot par1Slot, int par2, int par3, ClickType par4) {
        if (par1Slot != null) {
            if (par1Slot.field_75222_d == 48) {
                par1Slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                this.inventory.setStackInSlot(48, par1Slot.func_75211_c());
            }
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_230712_o_.getClass();
        this.searchField = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 20, this.field_147009_r + 36, 89, 9, StringTextComponent.field_240750_d_);
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(true);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_212954_a(s -> this.updateCreativeSearch());
        this.func_230480_a_((Widget)this.searchField);
        this.func_231035_a_((IGuiEventListener)this.searchField);
        this.searchField.func_146195_b(true);
        this.updateCreativeSearch();
    }

    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        if (this.parentScreen != null) {
            this.field_230706_i_.func_147108_a(this.parentScreen);
            if (this.parentScreen instanceof ContainerScreen) {
                this.field_230706_i_.field_71439_g.field_71070_bA = ((ContainerScreen)this.parentScreen).func_212873_a_();
            }
        } else {
            super.func_231175_as__();
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.parentScreen instanceof GuiArmorMainScreen && this.field_230706_i_.field_71439_g.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != ModItems.PNEUMATIC_HELMET.get()) {
            this.func_231175_as__();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.func_231175_as__();
        }
        return !this.searchField.func_231046_a_(keyCode, scanCode, modifiers) && this.searchField.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void getAllEnchantedBooks(Enchantment enchantment, NonNullList<ItemStack> list) {
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151134_bR);
            itemstack.func_77966_a(enchantment, i);
            list.add((Object)itemstack);
        }
    }

    private Stream<SearchEntry> getSearchEntries() {
        if (cachedSearchEntries == null) {
            NonNullList itemList = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (item == null) continue;
                itemList.add((Object)new ItemStack((IItemProvider)item));
            }
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
                if (enchantment == null || enchantment.field_77351_y == null) continue;
                this.getAllEnchantedBooks(enchantment, (NonNullList<ItemStack>)itemList);
            }
            cachedSearchEntries = itemList.stream().map(x$0 -> new SearchEntry((ItemStack)x$0)).collect(Collectors.toList());
        }
        return cachedSearchEntries.stream();
    }

    private void updateCreativeSearch() {
        ((ContainerItemSearcher)this.field_147002_h).itemList.clear();
        String s = this.searchField.func_146179_b().toLowerCase();
        List applicableEntries = this.getSearchEntries().filter(entry -> entry.test(s)).map(entry -> entry.stack).collect(Collectors.toList());
        ((ContainerItemSearcher)this.field_147002_h).itemList.addAll(applicableEntries);
        this.currentScroll = 0.0f;
        ((ContainerItemSearcher)this.field_147002_h).scrollTo(0.0f);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int par1, int par2) {
        this.field_230712_o_.func_238421_b_(matrixStack, "Item Searcher", 23.0f, 5.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Search Box", 23.0f, 25.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrixStack, "Target", 113.0f, 10.0f, 0x404040);
    }

    private boolean needsScrollBars() {
        return ((ContainerItemSearcher)this.field_147002_h).hasMoreThan1PageOfItemsInList();
    }

    public boolean func_231043_a_(double x, double y, double dir) {
        if (dir != 0.0 && this.needsScrollBars()) {
            int j = ((ContainerItemSearcher)this.field_147002_h).itemList.size() / 9 - 5 + 1;
            float i = dir > 0.0 ? 1.0f : -1.0f;
            this.currentScroll = MathHelper.func_76131_a((float)(this.currentScroll - i / (float)j), (float)0.0f, (float)1.0f);
            ((ContainerItemSearcher)this.field_147002_h).scrollTo(this.currentScroll);
            return true;
        }
        return super.func_231043_a_(x, y, dir);
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        boolean isLeftClicking = this.field_230706_i_.field_71474_y.field_74312_F.func_151470_d();
        int x1 = this.field_147003_i + 156;
        int y1 = this.field_147009_r + 48;
        int x2 = x1 + 14;
        int y2 = y1 + 112;
        if (!this.wasClicking && isLeftClicking && x >= x1 && y >= y1 && x < x2 && y < y2) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!isLeftClicking) {
            this.isScrolling = false;
        }
        this.wasClicking = isLeftClicking;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - y1) - 7.5f) / ((float)(y2 - y1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerItemSearcher)this.field_147002_h).scrollTo(this.currentScroll);
        }
        if (this.firstRun) {
            this.firstRun = false;
            ((ContainerItemSearcher)this.field_147002_h).scrollTo(0.0f);
        }
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        this.func_230459_a_(matrixStack, x, y);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float par1, int par2, int par3) {
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.field_147003_i + 156;
        int k = this.field_147009_r + 48;
        int l = k + 112;
        this.field_230706_i_.func_110434_K().func_110577_a(SCROLL_TEXTURE);
        this.func_238474_b_(matrixStack, i1, k + (int)((float)(l - k - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public class SearchEntry
    implements Predicate<String> {
        public final ItemStack stack;
        private final String tooltip;

        SearchEntry(ItemStack stack) {
            this.stack = stack;
            List t = stack.func_82840_a((PlayerEntity)((GuiItemSearcher)GuiItemSearcher.this).field_230706_i_.field_71439_g, (ITooltipFlag)(((GuiItemSearcher)GuiItemSearcher.this).field_230706_i_.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)).stream().map(ITextComponent::getString).collect(Collectors.toList());
            this.tooltip = StringUtils.join(t, (String)"\n").toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

