/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.inventory.ContainerJackhammerSetup;
import me.desht.pneumaticcraft.common.item.ItemDrillBit;
import me.desht.pneumaticcraft.common.item.ItemJackHammer;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiJackHammerSetup
extends GuiPneumaticContainerBase<ContainerJackhammerSetup, TileEntityBase> {
    private final WidgetButtonExtended[] typeButtons = new WidgetButtonExtended[ItemJackHammer.DigMode.values().length];
    private WidgetButtonExtended selectorButton;

    public GuiJackHammerSetup(ContainerJackhammerSetup container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 182;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        ItemStack hammerStack = this.field_213127_e.field_70458_d.func_184586_b(((ContainerJackhammerSetup)this.field_147002_h).getHand());
        ItemJackHammer.DigMode digMode = ItemJackHammer.getDigMode(hammerStack);
        if (digMode != null) {
            this.selectorButton = new WidgetButtonExtended(this.field_147003_i + 127, this.field_147009_r + 67, 20, 20, "", b -> this.toggleShowChoices());
            ((WidgetButtonExtended)this.func_230480_a_((Widget)this.selectorButton)).setRenderedIcon(digMode.getGuiIcon());
            int xBase = 147 - 20 * this.typeButtons.length;
            for (ItemJackHammer.DigMode dm : ItemJackHammer.DigMode.values()) {
                this.typeButtons[dm.ordinal()] = new WidgetButtonExtended(this.field_147003_i + xBase + 20 * dm.ordinal(), this.field_147009_r + 47, 20, 20, "", b -> this.selectDigMode(dm)).setRenderedIcon(dm.getGuiIcon()).withTag("digmode:" + dm.toString());
                this.typeButtons[dm.ordinal()].field_230694_p_ = false;
                this.func_230480_a_((Widget)this.typeButtons[dm.ordinal()]);
            }
        }
        this.func_230480_a_(new WidgetTooltipArea(this.field_147003_i + 96, this.field_147009_r + 19, 18, 18, new ITextComponent[0]){

            @Override
            public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shiftPressed) {
                if (!((Slot)((ContainerJackhammerSetup)((GuiJackHammerSetup)GuiJackHammerSetup.this).field_147002_h).field_75151_b.get(1)).func_75216_d()) {
                    curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.jackhammer.enchantedBookTip", new Object[0]));
                }
            }
        });
    }

    private void selectDigMode(ItemJackHammer.DigMode digMode) {
        Arrays.stream(this.typeButtons).forEach(button -> {
            button.field_230694_p_ = false;
        });
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    private void toggleShowChoices() {
        Arrays.stream(this.typeButtons).forEach(button -> {
            button.field_230694_p_ = !button.field_230694_p_;
        });
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateDigModeButtons();
    }

    private void updateDigModeButtons() {
        ItemStack drillStack = ((ContainerJackhammerSetup)this.field_147002_h).func_75139_a(0).func_75211_c();
        ItemDrillBit.DrillBitType bitType = drillStack.func_77973_b() instanceof ItemDrillBit ? ((ItemDrillBit)drillStack.func_77973_b()).getType() : ItemDrillBit.DrillBitType.NONE;
        ItemStack hammerStack = this.field_213127_e.field_70458_d.func_184586_b(((ContainerJackhammerSetup)this.field_147002_h).getHand());
        ItemJackHammer.DigMode digMode = ItemJackHammer.getDigMode(hammerStack);
        if (digMode == null) {
            digMode = ItemJackHammer.DigMode.MODE_1X1;
        }
        for (ItemJackHammer.DigMode dm : ItemJackHammer.DigMode.values()) {
            this.typeButtons[dm.ordinal()].field_230693_o_ = dm.getBitType().getTier() <= bitType.getTier();
        }
        if (digMode.getBitType().getTier() > bitType.getTier() && digMode != ItemJackHammer.DigMode.MODE_1X1) {
            digMode = ItemJackHammer.DigMode.MODE_1X1;
            NetworkHandler.sendToServer(new PacketGuiButton("digmode:" + digMode.toString()));
        }
        this.selectorButton.setRenderedIcon(digMode.getGuiIcon());
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        if (!((Slot)((ContainerJackhammerSetup)this.field_147002_h).field_75151_b.get(0)).func_75216_d()) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.jackhammer.noBit", (Object[])new Object[0]));
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_JACKHAMMER_SETUP;
    }
}

