/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMicromissile
extends GuiPneumaticScreenBase {
    private static final Rectangle2d SELECTOR_BOUNDS = new Rectangle2d(12, 21, 92, 81);
    private static final int MAX_DIST = SELECTOR_BOUNDS.func_199316_c();
    private static final PointXY TOP_SPEED_PT = new PointXY(46, 1);
    private static final PointXY TURN_SPEED_PT = new PointXY(1, 80);
    private static final PointXY DMG_PT = new PointXY(92, 80);
    private float turnSpeed;
    private float topSpeed;
    private float damage;
    private PointXY point;
    private ItemMicromissiles.FireMode fireMode;
    private boolean dragging = false;
    private String entityFilter;
    private int sendTimer = 0;
    private final Hand hand;
    private WidgetTextField textField;
    private WidgetLabel filterLabel;
    private WidgetButtonExtended modeButton;
    private WidgetButtonExtended warningButton;

    private GuiMicromissile(ITextComponent title, Hand hand) {
        super(title);
        this.xSize = 183;
        this.ySize = 191;
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.MICROMISSILES.get() && stack.func_77942_o()) {
            this.topSpeed = NBTUtils.getFloat(stack, "topSpeed");
            this.turnSpeed = NBTUtils.getFloat(stack, "turnSpeed");
            this.damage = NBTUtils.getFloat(stack, "damage");
            this.entityFilter = NBTUtils.getString(stack, "filter");
            this.point = new PointXY(NBTUtils.getInteger(stack, "px"), NBTUtils.getInteger(stack, "py"));
            this.fireMode = ItemMicromissiles.FireMode.fromString(NBTUtils.getString(stack, "fireMode"));
            this.hand = hand;
        } else {
            this.damage = 0.33333334f;
            this.turnSpeed = 0.33333334f;
            this.topSpeed = 0.33333334f;
            this.point = new PointXY(MAX_DIST / 2, MAX_DIST / 4);
            this.entityFilter = "";
            this.fireMode = ItemMicromissiles.FireMode.SMART;
            this.hand = Hand.MAIN_HAND;
        }
    }

    public static void openGui(ITextComponent title, Hand handIn) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiMicromissile(title, handIn));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        TranslationTextComponent labelStr = PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]);
        this.filterLabel = new WidgetLabel(this.guiLeft + 12, this.guiTop + 130, (ITextComponent)labelStr);
        this.func_230480_a_(this.filterLabel);
        int textBoxX = this.guiLeft + 12 + this.field_230712_o_.func_238414_a_((ITextProperties)labelStr) + 5;
        int textBoxWidth = this.xSize - (textBoxX - this.guiLeft) - 20;
        this.textField = new WidgetTextField(this.field_230712_o_, textBoxX, this.guiTop + 128, textBoxWidth, 10);
        this.textField.func_146180_a(this.entityFilter);
        this.func_231035_a_((IGuiEventListener)this.textField);
        this.textField.func_146195_b(true);
        this.textField.func_212954_a(s -> {
            this.entityFilter = s;
            if (this.validateEntityFilter(this.entityFilter)) {
                this.sendTimer = 5;
            }
        });
        this.func_230480_a_((Widget)this.textField);
        this.func_230480_a_(new WidgetTooltipArea(this.guiLeft + 42, this.guiTop + 9, 35, 9, new ITextComponent[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0])}));
        this.func_230480_a_(new WidgetTooltipArea(this.guiLeft + 6, this.guiTop + 103, 25, 12, new ITextComponent[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0])}));
        this.func_230480_a_(new WidgetTooltipArea(this.guiLeft + 96, this.guiTop + 103, 15, 15, new ITextComponent[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0])}));
        TranslationTextComponent saveLabel = PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.saveDefault", new Object[0]);
        int buttonWidth = this.field_230712_o_.func_238414_a_((ITextProperties)saveLabel) + 10;
        int buttonX = this.guiLeft + (this.xSize - buttonWidth) / 2;
        this.func_230480_a_((Widget)new WidgetButtonExtended(buttonX, this.guiTop + 160, buttonWidth, 20, (ITextComponent)saveLabel, b -> this.sendSettingsToServer(true)));
        this.modeButton = new WidgetButtonExtended(this.guiLeft + 123, this.guiTop + 20, 52, 20, StringTextComponent.field_240750_d_, b -> this.modeSwitch());
        this.modeButton.setTooltipText(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)"pneumaticcraft.gui.micromissile.modeTooltip", (Object[])new Object[0]), 40));
        this.func_230480_a_((Widget)this.modeButton);
        this.warningButton = new WidgetButtonExtended(this.guiLeft + 162, this.guiTop + 123, 20, 20);
        this.warningButton.setVisible(false);
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        this.func_230480_a_((Widget)this.warningButton);
        this.validateEntityFilter(this.entityFilter);
        this.setupWidgets();
    }

    private void modeSwitch() {
        int n = this.fireMode.ordinal() + 1;
        if (n >= ItemMicromissiles.FireMode.values().length) {
            n = 0;
        }
        this.fireMode = ItemMicromissiles.FireMode.values()[n];
        this.setupWidgets();
        this.sendSettingsToServer(false);
    }

    private void setupWidgets() {
        this.textField.func_146184_c(this.fireMode == ItemMicromissiles.FireMode.SMART);
        this.filterLabel.setColor(this.fireMode == ItemMicromissiles.FireMode.SMART ? -12566464 : -5592406);
        this.modeButton.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate(this.fireMode.getTranslationKey(), new Object[0]));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(matrixStack, this, this.field_230712_o_, PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        } else if (this.textField.func_230449_g_()) {
            String str = I18n.func_135052_a((String)"pneumaticcraft.gui.entityFilter", (Object[])new Object[0]);
            this.field_230712_o_.func_238421_b_(matrixStack, str, (float)this.guiLeft + (float)(this.xSize - this.field_230712_o_.func_78256_a(str)) / 2.0f, (float)(this.guiTop + this.ySize + 5), 0x808080);
        }
        if (this.fireMode == ItemMicromissiles.FireMode.DUMB) {
            return;
        }
        RenderSystem.disableTexture();
        RenderSystem.disableLighting();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        if (this.point != null) {
            float px = this.point.x;
            float py = this.point.y;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(this.guiLeft + SELECTOR_BOUNDS.func_199318_a()), (double)(this.guiTop + SELECTOR_BOUNDS.func_199319_b()), 0.0);
            int size = this.dragging ? 5 : 3;
            RenderSystem.lineWidth((float)2.0f);
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            wr.func_227888_a_(posMat, px - (float)size, py, 0.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            wr.func_227888_a_(posMat, px + (float)size, py, 0.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            wr.func_227888_a_(posMat, px, py - (float)size, 0.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            wr.func_227888_a_(posMat, px, py + (float)size, 0.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)1.0f);
            wr.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            wr.func_227888_a_(posMat, px, py, 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            wr.func_227888_a_(posMat, (float)SELECTOR_BOUNDS.func_199316_c() / 2.0f, 0.0f, 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            wr.func_227888_a_(posMat, px, py, 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            wr.func_227888_a_(posMat, 0.0f, (float)SELECTOR_BOUNDS.func_199317_d(), 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            wr.func_227888_a_(posMat, px, py, 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            wr.func_227888_a_(posMat, (float)SELECTOR_BOUNDS.func_199316_c(), (float)SELECTOR_BOUNDS.func_199317_d(), 0.0f).func_225586_a_(32, 32, 32, 128).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            RenderSystem.disableBlend();
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.guiLeft, (double)this.guiTop, 0.0);
        GuiMicromissile.func_238467_a_((MatrixStack)matrixStack, (int)125, (int)48, (int)(125 + (int)(49.0f * this.topSpeed)), (int)54, (int)-16728064);
        GuiMicromissile.func_238467_a_((MatrixStack)matrixStack, (int)125, (int)68, (int)(125 + (int)(49.0f * this.turnSpeed)), (int)74, (int)-16728064);
        GuiMicromissile.func_238467_a_((MatrixStack)matrixStack, (int)125, (int)88, (int)(125 + (int)(49.0f * this.damage)), (int)94, (int)-16728064);
        matrixStack.func_227865_b_();
        RenderSystem.enableLighting();
        RenderSystem.enableTexture();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            this.sendSettingsToServer(false);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_MICROMISSILE;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.trySetPoint((int)mouseX, (int)mouseY)) {
            this.dragging = true;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.dragging) {
            this.sendSettingsToServer(false);
            this.dragging = false;
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.dragging) {
            this.trySetPoint((int)mouseX, (int)mouseY);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dx, dy);
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.field_230694_p_ = false;
            this.warningButton.setTooltipText(StringTextComponent.field_240750_d_);
            new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.field_230694_p_ = true;
            this.warningButton.setTooltipText((ITextComponent)new StringTextComponent(e.getMessage()).func_240699_a_(TextFormatting.GOLD));
            return false;
        }
    }

    private boolean trySetPoint(int mouseX, int mouseY) {
        PointXY p = this.getPoint(mouseX, mouseY);
        if (p != null) {
            double dSpeed = (double)MAX_DIST - p.distance(TOP_SPEED_PT);
            double dTurnSpd = (double)MAX_DIST - p.distance(TURN_SPEED_PT);
            double dDamage = (double)MAX_DIST - p.distance(DMG_PT);
            double total = dSpeed + dTurnSpd + dDamage;
            this.topSpeed = (float)(dSpeed / total);
            this.turnSpeed = (float)(dTurnSpd / total);
            this.damage = (float)(dDamage / total);
            this.point = p;
            return true;
        }
        return false;
    }

    private void sendSettingsToServer(boolean saveDefault) {
        NetworkHandler.sendToServer(new PacketUpdateMicromissileSettings(this.topSpeed, this.turnSpeed, this.damage, this.point, this.entityFilter, this.fireMode, saveDefault, this.hand));
    }

    private PointXY getPoint(int mouseX, int mouseY) {
        Rectangle2d r = new Rectangle2d(SELECTOR_BOUNDS.func_199318_a() + this.guiLeft, SELECTOR_BOUNDS.func_199319_b() + this.guiTop, SELECTOR_BOUNDS.func_199316_c(), SELECTOR_BOUNDS.func_199317_d());
        if (!r.func_199315_b(mouseX, mouseY)) {
            return null;
        }
        PointXY p = new PointXY(mouseX - r.func_199318_a(), mouseY - r.func_199319_b());
        return this.isPointInTriangle(p, TOP_SPEED_PT, TURN_SPEED_PT, DMG_PT) ? p : null;
    }

    private boolean isPointInTriangle(PointXY s, PointXY a, PointXY b, PointXY c) {
        boolean s_ab;
        int as_x;
        int as_y;
        if ((c.x - a.x) * as_y - (c.y - a.y) * as_x > 0 == (s_ab = (b.x - a.x) * (as_y = s.y - a.y) - (b.y - a.y) * (as_x = s.x - a.x) > 0)) {
            return false;
        }
        return (c.x - b.x) * (s.y - b.y) - (c.y - b.y) * (s.x - b.x) > 0 == s_ab;
    }
}

