/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.tileentity.TileEntityOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiOmnidirectionalHopper
extends GuiPneumaticContainerBase<ContainerOmnidirectionalHopper, TileEntityOmnidirectionalHopper> {
    private static final ITextComponent ARROW_NO_RR = new StringTextComponent("\u27f6");
    private static final ITextComponent ARROW_RR = new StringTextComponent("\u293e").func_240699_a_(TextFormatting.GREEN);
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];
    private WidgetButtonExtended rrButton;

    public GuiOmnidirectionalHopper(ContainerOmnidirectionalHopper container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.statusStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.hopperStatus", new Object[0]), new ItemStack((IItemProvider)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((IItemProvider)Blocks.field_150442_at), -13312, false);
        optionStat.addPadding(4, 14);
        WidgetButtonExtended button = new WidgetButtonExtended(5, 20, 20, 20, "").withTag("empty");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151133_ar));
        button.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.omnidirectionalHopper.mode.empty", new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(30, 20, 20, 20, "").withTag("leave");
        button.setRenderStacks(new ItemStack((IItemProvider)Items.field_151131_as));
        button.setTooltipText((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.omnidirectionalHopper.mode.leaveItem", new Object[0]));
        optionStat.addSubWidget((Widget)button);
        this.modeButtons[1] = button;
        this.rrButton = new WidgetButtonExtended(this.field_147003_i + 143, this.field_147009_r + 55, 14, 14, "").withTag("rr");
        this.func_230480_a_((Widget)this.rrButton);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_OMNIDIRECTIONAL_HOPPER;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].field_230693_o_ = ((TileEntityOmnidirectionalHopper)this.te).doesLeaveMaterial();
        this.modeButtons[1].field_230693_o_ = !((TileEntityOmnidirectionalHopper)this.te).doesLeaveMaterial();
        this.rrButton.func_238482_a_(((TileEntityOmnidirectionalHopper)this.te).roundRobin ? ARROW_RR : ARROW_NO_RR);
        this.rrButton.setTooltipText(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)("pneumaticcraft.gui.tooltip.omnidirectional_hopper.roundRobin." + (((TileEntityOmnidirectionalHopper)this.te).roundRobin ? "on" : "off")), (Object[])new Object[0])));
    }

    private List<String> getStatus() {
        ArrayList<String> textList = new ArrayList<String>();
        int itemsPer = ((TileEntityOmnidirectionalHopper)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.hopperStatus.itemTransferPerTick", (Object[])new Object[]{itemsPer}));
        } else {
            int transferInterval = ((TileEntityOmnidirectionalHopper)this.te).getItemTransferInterval();
            textList.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.hopperStatus.itemTransferPerSecond", (Object[])new Object[]{transferInterval == 0 ? "20" : PneumaticCraftUtils.roundNumberTo(20.0f / (float)transferInterval, 1)}));
        }
        return textList;
    }

    @Override
    protected void addExtraUpgradeText(List<String> text) {
        if (PNCConfig.Common.Machines.omniHopperDispenser) {
            text.add("pneumaticcraft.gui.tab.upgrades.tile.omnidirectional_hopper.dispenser");
        }
        text.add("pneumaticcraft.gui.tab.upgrades.creative");
    }
}

