/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.widget.ITickableWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticBase;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.TextVariableParser;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModList;

public abstract class GuiPneumaticContainerBase<C extends ContainerPneumaticBase<T>, T extends TileEntityBase>
extends ContainerScreen<C> {
    public final T te;
    private IGuiAnimatedStat lastLeftStat;
    private IGuiAnimatedStat lastRightStat;
    private WidgetAnimatedStat pressureStat;
    private WidgetAnimatedStat redstoneTab;
    WidgetAnimatedStat problemTab;
    private WidgetButtonExtended redstoneButton;
    boolean firstUpdate = true;
    private final List<IGuiAnimatedStat> statWidgets = new ArrayList<IGuiAnimatedStat>();
    private int sendDelay = -1;
    boolean redstoneAllows;

    public GuiPneumaticContainerBase(C container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.te = ((ContainerPneumaticBase)container).te;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        if (this.shouldAddPressureTab() && this.te instanceof TileEntityPneumaticBase) {
            this.pressureStat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.pressure", new Object[0]), new ItemStack((IItemProvider)ModBlocks.PRESSURE_TUBE.get()), -16733696, false);
        }
        if (this.shouldAddProblemTab()) {
            this.problemTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]), -6250336, false);
        }
        if (this.te != null) {
            if (this.shouldAddInfoTab()) {
                this.addInfoTab(ICustomTooltipName.getTranslationKey(new ItemStack((IItemProvider)this.te.func_195044_w().func_177230_c()), false));
            }
            if (this.shouldAddRedstoneTab() && this.te instanceof IRedstoneControl) {
                this.addRedstoneTab();
            }
            if (this.te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
                this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.heat.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151065_br), -2075392, false).setText("pneumaticcraft.gui.tab.info.heat");
            }
            if (this.shouldAddUpgradeTab()) {
                this.addUpgradeTab();
            }
            if (this.shouldAddSideConfigTabs()) {
                this.addSideConfiguratorTabs();
            }
        }
    }

    private WidgetAnimatedStat addAnimatedStat(ITextComponent title, WidgetAnimatedStat.StatIcon icon, int color, boolean leftSided) {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        WidgetAnimatedStat stat = new WidgetAnimatedStat((Screen)this, title, icon, xStart + (leftSided ? 0 : this.field_146999_f + 1), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : yStart + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        stat.setBeveled(true);
        this.func_230480_a_(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        this.statWidgets.add(stat);
        return stat;
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, @Nonnull ItemStack icon, int color, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), color, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, ResourceLocation icon, int color, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.of(icon), color, leftSided);
    }

    protected WidgetAnimatedStat addAnimatedStat(ITextComponent title, int color, boolean leftSided) {
        return this.addAnimatedStat(title, WidgetAnimatedStat.StatIcon.NONE, color, leftSided);
    }

    protected void addLabel(ITextComponent text, int x, int y) {
        this.func_230480_a_(new WidgetLabel(x, y, text));
    }

    protected void addLabel(ITextComponent text, int x, int y, int color) {
        this.func_230480_a_(new WidgetLabel(x, y, text, color));
    }

    void removeWidget(Widget widget) {
        this.field_230710_m_.remove(widget);
        this.field_230705_e_.remove(widget);
        if (widget instanceof IGuiAnimatedStat) {
            this.statWidgets.remove(widget);
        }
    }

    public List<IGuiAnimatedStat> getStatWidgets() {
        return this.statWidgets;
    }

    private void addRedstoneTab() {
        this.redstoneTab = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour", new Object[0]), new ItemStack((IItemProvider)Items.field_151137_ax), -3407872, true);
        ArrayList<String> curInfo = new ArrayList<String>();
        curInfo.add(((TileEntityBase)this.te).getRedstoneTabTitle().getString());
        int width = this.getWidestRedstoneLabel();
        this.redstoneTab.addPadding(curInfo, 4, width / this.field_230712_o_.func_78256_a(" "));
        Rectangle2d buttonRect = this.redstoneTab.getButtonScaledRectangle(-width - 12, 24, width + 10, 20);
        this.redstoneButton = new WidgetButtonExtended(buttonRect.func_199318_a(), buttonRect.func_199319_b(), buttonRect.func_199316_c(), buttonRect.func_199317_d(), "-", button -> {}).withTag("redstone");
        this.redstoneTab.addSubWidget((Widget)this.redstoneButton);
    }

    protected void addJeiFilterInfoTab() {
        if (ModList.get().isLoaded("jei")) {
            this.addAnimatedStat((ITextComponent)new StringTextComponent("JEI"), Textures.GUI_JEI_LOGO, -3215922, true).setText(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.jei.filterDrag", (Object[])new Object[0]));
        }
    }

    protected String upgradeCategory() {
        return this.te.func_200662_C().getRegistryName().func_110623_a();
    }

    private void addUpgradeTab() {
        ArrayList<String> text = new ArrayList<String>();
        ((TileEntityBase)this.te).getApplicableUpgrades().keySet().stream().sorted(Comparator.comparing(o -> o.getItemStack().func_200301_q().getString())).forEach(upgrade -> {
            int max = ((TileEntityBase)this.te).getApplicableUpgrades().get(upgrade);
            text.add(TextFormatting.WHITE + "" + TextFormatting.UNDERLINE + upgrade.getItemStack().func_200301_q().getString());
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"pneumaticcraft.gui.tab.upgrades.max", (Object[])new Object[]{max}));
            String upgradeName = upgrade.toString().toLowerCase();
            String k = "pneumaticcraft.gui.tab.upgrades." + this.upgradeCategory() + "." + upgradeName;
            text.add(TextFormatting.BLACK + (I18n.func_188566_a((String)k) ? I18n.func_135052_a((String)k, (Object[])new Object[0]) : I18n.func_135052_a((String)("pneumaticcraft.gui.tab.upgrades.generic." + upgradeName), (Object[])new Object[0])));
            text.add("");
        });
        if (!text.isEmpty()) {
            this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.upgrades", new Object[0]), Textures.GUI_UPGRADES_LOCATION, -10460929, true).setText(text);
        }
    }

    protected void addExtraUpgradeText(List<String> upgradeText) {
    }

    private int getWidestRedstoneLabel() {
        int max = 0;
        for (int i = 0; i < ((TileEntityBase)this.te).getRedstoneModeCount(); ++i) {
            max = Math.max(max, this.field_230712_o_.func_238414_a_((ITextProperties)((TileEntityBase)this.te).getRedstoneButtonText(i)));
        }
        return max;
    }

    private void addSideConfiguratorTabs() {
        for (SideConfigurator<?> sc : ((ISideConfigurable)this.te).getSideConfigurators()) {
            WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate(sc.getTranslationKey(), new Object[0]), new ItemStack((IItemProvider)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
            stat.addPadding(7, 16);
            int yTop = 15;
            int xLeft = 25;
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
            stat.addSubWidget((Widget)this.makeSideConfButton(sc, SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
        }
    }

    private WidgetButtonExtended makeSideConfButton(SideConfigurator<?> sideConfigurator, SideConfigurator.RelativeFace relativeFace, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, "", b -> {
            WidgetButtonExtended gbs = (WidgetButtonExtended)b;
            ((ISideConfigurable)this.te).getSideConfigurators().stream().filter(sc -> sc.handleButtonPress(gbs.getTag())).findFirst().ifPresent(sc -> this.setupSideConfiguratorButton((SideConfigurator<?>)sc, gbs));
        }).withTag("SideConf." + relativeFace.toString());
        this.setupSideConfiguratorButton(sideConfigurator, button);
        return button;
    }

    private void setupSideConfiguratorButton(SideConfigurator<?> sc, WidgetButtonExtended button) {
        try {
            SideConfigurator.RelativeFace relativeFace = SideConfigurator.RelativeFace.valueOf(button.getTag().split("\\.")[1]);
            SideConfigurator.ConnectionEntry<?> c = sc.getEntry(relativeFace);
            if (c != null && c.getTexture() != null) {
                button.setTexture(c.getTexture());
            } else {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
            }
            button.setTooltipText((List<ITextComponent>)ImmutableList.of((Object)new StringTextComponent(relativeFace.toString()).func_240699_a_(TextFormatting.YELLOW), (Object)sc.getFaceLabel(relativeFace)));
        }
        catch (IllegalArgumentException e) {
            Log.warning("Bad tag '" + button.getTag() + "'", new Object[0]);
        }
    }

    protected void addInfoTab(String info) {
        WidgetAnimatedStat stat = this.addAnimatedStat((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), Textures.GUI_INFO_LOCATION, -7829249, true);
        stat.setText(info);
        if (!ThirdPartyManager.instance().getDocsProvider().isInstalled()) {
            stat.appendText(Arrays.asList("", "pneumaticcraft.gui.tab.info.installDocsProvider"));
        }
    }

    protected boolean shouldAddRedstoneTab() {
        return true;
    }

    protected boolean shouldAddPressureTab() {
        return true;
    }

    protected boolean shouldAddUpgradeTab() {
        return true;
    }

    protected boolean shouldAddInfoTab() {
        return true;
    }

    protected boolean shouldAddProblemTab() {
        return true;
    }

    protected boolean shouldAddSideConfigTabs() {
        return this.te instanceof ISideConfigurable;
    }

    protected int getBackgroundTint() {
        return 0xFFFFFF;
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int i, int j) {
        if (this.shouldDrawBackground()) {
            GuiUtils.glColorHex(0xFF000000 | this.getBackgroundTint());
            this.bindGuiTexture();
            int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
            int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrixStack, xStart, yStart, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        PointXY gaugeLocation;
        if (this.getInvNameOffset() != null) {
            this.field_230712_o_.func_238422_b_(matrixStack, this.field_230704_d_.func_241878_f(), (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) / 2.0f + (float)this.getInvNameOffset().x, (float)(5 + this.getInvNameOffset().y), this.getTitleColor());
        }
        if (this.getInvTextOffset() != null) {
            this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), (float)(8 + this.getInvTextOffset().x), (float)(this.field_147000_g - 94 + this.getInvTextOffset().y), 0x404040);
        }
        if (this.pressureStat != null && (gaugeLocation = this.getGaugeLocation()) != null) {
            TileEntityPneumaticBase pneu = (TileEntityPneumaticBase)this.te;
            float minWorking = this.te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)this.te).getMinWorkingPressure() : -3.4028235E38f;
            PressureGaugeRenderer2D.drawPressureGauge(matrixStack, this.field_230712_o_, -1.0f, pneu.criticalPressure, pneu.dangerPressure, minWorking, pneu.getPressure(), gaugeLocation.x - this.field_147003_i, gaugeLocation.y - this.field_147009_r);
        }
    }

    void bindGuiTexture() {
        ResourceLocation guiTexture = this.getGuiTexture();
        if (guiTexture != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(guiTexture);
            RenderSystem.enableTexture();
        }
    }

    protected abstract ResourceLocation getGuiTexture();

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        for (IGuiAnimatedStat w : this.statWidgets) {
            if (!((WidgetAnimatedStat)w).func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY)) continue;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTick) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTick);
        this.func_230459_a_(matrixStack, x, y);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof ITooltipProvider) || !widget.func_230449_g_() || !widget.field_230694_p_) continue;
            ((ITooltipProvider)widget).addTooltip(x, y, tooltip, Screen.func_231173_s_());
        }
        if (this.shouldParseVariablesInTooltips()) {
            for (int i = 0; i < tooltip.size(); ++i) {
                tooltip.set(i, (ITextComponent)new StringTextComponent(new TextVariableParser(((ITextComponent)tooltip.get(i)).getString()).parse()));
            }
        }
        if (tooltip.size() > 0) {
            this.drawHoveringString(matrixStack, tooltip, x, y, this.field_230712_o_);
        }
    }

    protected PointXY getGaugeLocation() {
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        return new PointXY(xStart + this.field_146999_f * 3 / 4, yStart + this.field_147000_g / 4 + 4);
    }

    protected int getTitleColor() {
        return 0x404040;
    }

    protected PointXY getInvNameOffset() {
        return PointXY.ZERO;
    }

    protected PointXY getInvTextOffset() {
        return PointXY.ZERO;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.sendDelay > 0 && --this.sendDelay <= 0) {
            this.doDelayedAction();
            this.sendDelay = -1;
        }
        this.field_230710_m_.stream().filter(w -> w instanceof ITickableWidget).forEach(w -> ((ITickableWidget)w).tickWidget());
        if (this.pressureStat != null) {
            ArrayList<String> pressureText = new ArrayList<String>();
            this.addPressureStatInfo(pressureText);
            this.pressureStat.setText(pressureText);
        }
        if (this.problemTab != null && ((Minecraft.func_71410_x().field_71441_e.func_82737_E() & 7L) == 0L || this.firstUpdate)) {
            this.handleProblemsTab();
        }
        if (this.redstoneTab != null) {
            this.redstoneButton.func_238482_a_(((TileEntityBase)this.te).getRedstoneButtonText(((IRedstoneControl)this.te).getRedstoneMode()));
        }
        if (this.te instanceof IRedstoneControlled) {
            this.redstoneAllows = ((TileEntityBase)this.te).redstoneAllows();
        }
        this.firstUpdate = false;
    }

    private void handleProblemsTab() {
        ArrayList<String> problemText = new ArrayList<String>();
        this.addProblems(problemText);
        int nProbs = problemText.size();
        this.addWarnings(problemText);
        int nWarnings = problemText.size() - nProbs;
        this.addInformation(problemText);
        if (nProbs > 0) {
            this.problemTab.setTexture(Textures.GUI_PROBLEMS_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems", new Object[0]));
            this.problemTab.setBackgroundColor(-65536);
        } else if (nWarnings > 0) {
            this.problemTab.setTexture(Textures.GUI_WARNING_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.warning", new Object[0]));
            this.problemTab.setBackgroundColor(-4145152);
        } else {
            this.problemTab.setTexture(Textures.GUI_NO_PROBLEMS_TEXTURE);
            this.problemTab.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.problems.noProblems", new Object[0]));
            this.problemTab.setBackgroundColor(-6226016);
        }
        if (problemText.isEmpty()) {
            problemText.add("");
        }
        this.problemTab.setText(problemText);
    }

    protected void addPressureStatInfo(List<String> pressureStatText) {
        this.te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(airHandler -> {
            String col = TextFormatting.BLACK.toString();
            float curPressure = airHandler.getPressure();
            int volume = airHandler.getVolume();
            int upgrades = ((TileEntityBase)this.te).getUpgrades(EnumUpgrade.VOLUME);
            airHandler.setVolumeUpgrades(upgrades);
            pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(curPressure, 2)}));
            pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.air", (Object[])new Object[]{String.format("%,d", Math.round(curPressure * (float)volume))}));
            pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.baseVolume", (Object[])new Object[]{String.format("%,d", airHandler.getBaseVolume())}));
            if (volume > airHandler.getBaseVolume()) {
                pressureStatText.add(col + "\u25b6" + " " + upgrades + " x " + EnumUpgrade.VOLUME.getItemStack().func_200301_q().getString());
                pressureStatText.add(col + I18n.func_135052_a((String)"pneumaticcraft.gui.tooltip.effectiveVolume", (Object[])new Object[]{String.format("%,d", volume)}));
            }
        });
    }

    protected void addProblems(List<String> curInfo) {
        if (this.te instanceof IMinWorkingPressure) {
            IMinWorkingPressure minWork = (IMinWorkingPressure)this.te;
            if (((TileEntityPneumaticBase)this.te).getPressure() < minWork.getMinWorkingPressure()) {
                curInfo.add("pneumaticcraft.gui.tab.problems.notEnoughPressure");
                curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.applyPressure", (Object[])new Object[]{Float.valueOf(minWork.getMinWorkingPressure())}));
            }
        }
    }

    protected void addInformation(List<String> curInfo) {
    }

    protected void addWarnings(List<String> curInfo) {
        if (this.te instanceof IRedstoneControlled && !this.redstoneAllows) {
            IRedstoneControlled redstoneControlled = (IRedstoneControlled)this.te;
            curInfo.add("pneumaticcraft.gui.tab.problems.redstoneDisallows");
            if (redstoneControlled.getRedstoneMode() == 1) {
                curInfo.add("pneumaticcraft.gui.tab.problems.provideRedstone");
            } else {
                curInfo.add("pneumaticcraft.gui.tab.problems.removeRedstone");
            }
        }
    }

    void sendGUIButtonPacketToServer(String tag) {
        NetworkHandler.sendToServer(new PacketGuiButton(tag));
    }

    void drawHoveringString(MatrixStack matrixStack, List<? extends ITextProperties> text, int x, int y, FontRenderer fontRenderer) {
        net.minecraftforge.fml.client.gui.GuiUtils.drawHoveringText((MatrixStack)matrixStack, text, (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)fontRenderer);
    }

    WidgetButtonExtended getButtonFromRectangle(String tag, Rectangle2d buttonSize, String buttonText, Button.IPressable pressable) {
        return new WidgetButtonExtended(buttonSize.func_199318_a(), buttonSize.func_199319_b(), buttonSize.func_199316_c(), buttonSize.func_199317_d(), buttonText, pressable).withTag(tag);
    }

    WidgetButtonExtended getInvisibleButtonFromRectangle(String tag, Rectangle2d buttonSize, Button.IPressable pressable) {
        return new WidgetButtonExtended(buttonSize.func_199318_a(), buttonSize.func_199319_b(), buttonSize.func_199316_c(), buttonSize.func_199317_d(), "", pressable).withTag(tag);
    }

    WidgetTextField getTextFieldFromRectangle(Rectangle2d textFieldSize) {
        return new WidgetTextField(this.field_230712_o_, textFieldSize.func_199318_a(), textFieldSize.func_199319_b(), textFieldSize.func_199316_c(), textFieldSize.func_199317_d());
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public Collection<Rectangle2d> getTabRectangles() {
        return this.getStatWidgets().stream().map(IGuiAnimatedStat::getBounds).collect(Collectors.toList());
    }

    void refreshScreen() {
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        int i = mw.func_198107_o();
        int j = mw.func_198087_p();
        this.func_231158_b_(Minecraft.func_71410_x(), i, j);
        this.field_230710_m_.stream().filter(widget -> widget instanceof ITickable).forEach(w -> ((ITickable)w).func_110550_d());
    }

    protected void sendDelayed(int ticks) {
        this.sendDelay = ticks;
    }

    protected void doDelayedAction() {
    }

    public void func_231164_f_() {
        if (this.sendDelay > 0) {
            this.doDelayedAction();
        }
        super.func_231164_f_();
    }

    protected boolean shouldParseVariablesInTooltips() {
        return false;
    }
}

