/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerRefinery;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryOutput;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.IFluidTank;

public class GuiRefineryController
extends GuiPneumaticContainerBase<ContainerRefinery, TileEntityRefineryController> {
    private List<TileEntityRefineryOutput> outputs;
    private WidgetTemperature widgetTemperature;
    private int nExposedFaces;

    public GuiRefineryController(ContainerRefinery container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 189;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.widgetTemperature = new WidgetTemperature(this.field_147003_i + 32, this.field_147009_r + 32, TemperatureRange.of(273, 673), 273, 50);
        this.func_230480_a_(this.widgetTemperature);
        this.func_230480_a_(new WidgetTank(this.field_147003_i + 8, this.field_147009_r + 25, (IFluidTank)((TileEntityRefineryController)this.te).getInputTank()));
        int x = this.field_147003_i + 95;
        int y = this.field_147009_r + 29;
        this.outputs = new ArrayList<TileEntityRefineryOutput>();
        TileEntityRefineryOutput te1 = ((TileEntityRefineryController)this.te).findAdjacentOutput();
        if (te1 instanceof TileEntityRefineryOutput) {
            int i = 0;
            do {
                TileEntityRefineryOutput teRO = te1;
                if (this.outputs.size() < 4) {
                    this.func_230480_a_(new WidgetTank(x, y, (IFluidTank)((TileEntityRefineryController)this.te).outputsSynced[i++]));
                }
                x += 20;
                y -= 4;
                this.outputs.add(teRO);
            } while ((te1 = te1.func_145831_w().func_175625_s(te1.func_174877_v().func_177984_a())) instanceof TileEntityRefineryOutput);
        }
        if (this.outputs.size() < 2 || this.outputs.size() > 4) {
            this.problemTab.openStat();
        }
        this.nExposedFaces = HeatUtil.countExposedFaces(this.outputs);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (((TileEntityRefineryController)this.te).maxTemp > ((TileEntityRefineryController)this.te).minTemp) {
            this.widgetTemperature.setOperatingRange(TemperatureRange.of(((TileEntityRefineryController)this.te).minTemp, ((TileEntityRefineryController)this.te).maxTemp));
        } else {
            this.widgetTemperature.setOperatingRange(null);
        }
        ((TileEntityRefineryController)this.te).getHeatCap(null).ifPresent(l -> this.widgetTemperature.setTemperature(l.getTemperatureAsInt()));
        this.widgetTemperature.autoScaleForTemperature();
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float f, int x, int y) {
        super.func_230450_a_(matrixStack, f, x, y);
        if (this.outputs.size() < 4) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            GuiRefineryController.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 155), (int)(this.field_147009_r + 17), (int)(this.field_147003_i + 171), (int)(this.field_147009_r + 81), (int)0x40FF0000);
            if (this.outputs.size() < 3) {
                GuiRefineryController.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 135), (int)(this.field_147009_r + 21), (int)(this.field_147003_i + 151), (int)(this.field_147009_r + 85), (int)0x40FF0000);
            }
            if (this.outputs.size() < 2) {
                GuiRefineryController.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 115), (int)(this.field_147009_r + 25), (int)(this.field_147003_i + 131), (int)(this.field_147009_r + 89), (int)0x40FF0000);
            }
            if (this.outputs.size() < 1) {
                GuiRefineryController.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_147003_i + 95), (int)(this.field_147009_r + 29), (int)(this.field_147003_i + 111), (int)(this.field_147009_r + 93), (int)0x40FF0000);
            }
            RenderSystem.disableBlend();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REFINERY;
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        int temp = (Integer)((TileEntityRefineryController)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
        if (temp < ((TileEntityRefineryController)this.te).minTemp) {
            curInfo.add("pneumaticcraft.gui.tab.problems.notEnoughHeat");
        }
        if (((TileEntityRefineryController)this.te).getInputTank().getFluidAmount() < 10) {
            curInfo.add("pneumaticcraft.gui.tab.problems.refinery.noOil");
        }
        if (this.outputs.size() < 2) {
            curInfo.add("pneumaticcraft.gui.tab.problems.refinery.notEnoughRefineries");
        } else if (this.outputs.size() > 4) {
            curInfo.add("pneumaticcraft.gui.tab.problems.refinery.tooManyRefineries");
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (((TileEntityRefineryController)this.te).isBlocked()) {
            curInfo.add("pneumaticcraft.gui.tab.problems.refinery.outputBlocked");
        }
        if (this.nExposedFaces > 0) {
            curInfo.add(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.exposedFaces", (Object[])new Object[]{this.nExposedFaces, this.outputs.size() * 6}));
        }
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }
}

