/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionBackground;
import me.desht.pneumaticcraft.client.gui.NetworkConnectionHandler;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationMain;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationAddUser;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiSecurityStationInventory
extends GuiSecurityStationBase<ContainerSecurityStationMain> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat accessStat;
    private WidgetButtonExtended addUserButton;
    private Button rebootButton;
    private WidgetTextField sharedUserTextField;
    private List<WidgetButtonExtended> removeUserButtons;
    private NetworkConnectionHandler nodeHandler;

    public GuiSecurityStationInventory(ContainerSecurityStationMain container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 239;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int xStart = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yStart = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.statusStat = this.addAnimatedStat((ITextComponent)new StringTextComponent("Security Status"), new ItemStack((IItemProvider)ModBlocks.SECURITY_STATION.get()), -22016, false);
        this.accessStat = this.addAnimatedStat((ITextComponent)new StringTextComponent("Shared Users"), new ItemStack((IItemProvider)Items.field_196184_dx), -16755456, false);
        Rectangle2d accessButtonRectangle = this.accessStat.getButtonScaledRectangle(145, 10, 20, 20);
        this.addUserButton = this.getButtonFromRectangle(null, accessButtonRectangle, "+", b -> {
            if (!this.sharedUserTextField.func_146179_b().equals("")) {
                NetworkHandler.sendToServer(new PacketSecurityStationAddUser(this.te, this.sharedUserTextField.func_146179_b()));
            }
        });
        this.rebootButton = new WidgetButtonExtended(xStart + 110, yStart + 20, 60, 20, "Reboot").withTag("reboot");
        this.sharedUserTextField = this.getTextFieldFromRectangle(this.accessStat.getButtonScaledRectangle(20, 15, 120, 10));
        this.sharedUserTextField.func_212954_a(s -> {
            ((TileEntitySecurityStation)this.te).setText(0, this.sharedUserTextField.func_146179_b());
            NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
        });
        this.accessStat.addSubWidget((Widget)this.sharedUserTextField);
        this.accessStat.addSubWidget((Widget)this.addUserButton);
        ((WidgetButtonExtended)this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 108, this.field_147009_r + 103, 64, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.securityStation.test", (Object[])new Object[0])))).withTag("test");
        this.func_230480_a_((Widget)this.rebootButton);
        this.func_230480_a_((Widget)new WidgetButtonExtended(this.field_147003_i + 108, this.field_147009_r + 125, 64, 20, I18n.func_135052_a((String)"pneumaticcraft.gui.button.showRange", (Object[])new Object[0]), b -> ((TileEntitySecurityStation)this.te).showRangeLines()));
        this.updateUserRemoveButtons();
        this.nodeHandler = new NetworkConnectionBackground(this, (TileEntitySecurityStation)this.te, xStart + 25, yStart + 30, 18, -14540033);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        this.field_230712_o_.func_238421_b_(matrixStack, "Network Layout", 15.0f, 12.0f, 0x404040);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SECURITY_STATION;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return new PointXY(0, 2);
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -2);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float opacity, int x, int y) {
        super.func_230450_a_(matrixStack, opacity, x, y);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.nodeHandler.render(matrixStack);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.statusStat.setText(this.getStatusText());
        this.accessStat.setTextWithoutCuttingString(this.getAccessText());
        String rebootButtonString = ((TileEntitySecurityStation)this.te).getRebootTime() > 0 ? (((TileEntitySecurityStation)this.te).getRebootTime() % 100 < 50 ? "Rebooting.." : PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false)) : "Reboot";
        this.rebootButton.func_238482_a_((ITextComponent)new StringTextComponent(rebootButtonString));
        this.addUserButton.field_230694_p_ = this.accessStat.isDoneExpanding();
        for (Button button : this.removeUserButtons) {
            button.field_230693_o_ = this.accessStat.isDoneExpanding();
        }
        if (this.removeUserButtons.size() != ((TileEntitySecurityStation)this.te).sharedUsers.size()) {
            this.updateUserRemoveButtons();
        }
    }

    @Override
    protected void addProblems(List<String> text) {
        super.addProblems(text);
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.add(TextFormatting.GRAY + "The Security Station doesn't provide security!");
            text.add(TextFormatting.BLACK + "The station is rebooting (" + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(((TileEntitySecurityStation)this.te).getRebootTime(), false) + ").");
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.add(TextFormatting.GRAY + "This Station has been hacked!");
            text.add(TextFormatting.BLACK + "Reboot the station.");
        }
        if (!((TileEntitySecurityStation)this.te).hasValidNetwork()) {
            text.add(TextFormatting.GRAY + "Invalid network configuration!");
            switch (((TileEntitySecurityStation)this.te).checkForNetworkValidity()) {
                case NO_SUBROUTINE: {
                    text.add(TextFormatting.BLACK + "Add a Diagnostic Subroutine.");
                    break;
                }
                case NO_IO_PORT: {
                    text.add(TextFormatting.BLACK + "Add a Network IO Port.");
                    break;
                }
                case NO_REGISTRY: {
                    text.add(TextFormatting.BLACK + "Add a Network Registry.");
                    break;
                }
                case TOO_MANY_SUBROUTINES: {
                    text.add(TextFormatting.BLACK + "There can only be one Diagnostic Subroutine.");
                    break;
                }
                case TOO_MANY_IO_PORTS: {
                    text.add(TextFormatting.BLACK + "There can only be one Network IO Port.");
                    break;
                }
                case TOO_MANY_REGISTRIES: {
                    text.add(TextFormatting.BLACK + "There can only be one Network Registry.");
                    break;
                }
                case NO_CONNECTION_SUB_AND_IO_PORT: {
                    text.add(TextFormatting.BLACK + "The Diagnostic Subroutine and the Network IO Port need to be connected in the network.");
                    break;
                }
                case NO_CONNECTION_IO_PORT_AND_REGISTRY: {
                    text.add(TextFormatting.BLACK + "The Network Registry and the Network IO Port need to be connected in the network.");
                }
            }
        }
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.GRAY + "Protection");
        if (((TileEntitySecurityStation)this.te).getRebootTime() > 0) {
            text.add(TextFormatting.DARK_RED + "No protection because of rebooting!");
        } else if (((TileEntitySecurityStation)this.te).isHacked()) {
            text.add(TextFormatting.DARK_RED + "Hacked by:");
            for (GameProfile hacker : ((TileEntitySecurityStation)this.te).hackedUsers) {
                text.add(TextFormatting.DARK_RED + "\u2022 " + hacker.getName());
            }
        } else {
            text.add(TextFormatting.BLACK + "System secure");
        }
        text.add(TextFormatting.GRAY + "Security Level");
        text.add(TextFormatting.BLACK + "Level " + ((TileEntitySecurityStation)this.te).getSecurityLevel());
        text.add(TextFormatting.GRAY + "Intruder Detection Chance");
        text.add(TextFormatting.BLACK.toString() + ((TileEntitySecurityStation)this.te).getDetectionChance() + "%%");
        text.add(TextFormatting.GRAY + "Security Range");
        text.add(TextFormatting.BLACK.toString() + ((TileEntitySecurityStation)this.te).getSecurityRange() + "m (square)");
        return text;
    }

    private List<String> getAccessText() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add("                                      ");
        textList.add("");
        for (GameProfile user : ((TileEntitySecurityStation)this.te).sharedUsers) {
            textList.add(TextFormatting.WHITE + "\u2022 " + user.getName());
        }
        return textList;
    }

    private void updateUserRemoveButtons() {
        if (this.removeUserButtons != null) {
            for (WidgetButtonExtended button : this.removeUserButtons) {
                this.accessStat.removeSubWidget((Widget)button);
            }
        }
        this.removeUserButtons = new ArrayList<WidgetButtonExtended>();
        for (int i = 0; i < ((TileEntitySecurityStation)this.te).sharedUsers.size(); ++i) {
            Rectangle2d rect = this.accessStat.getButtonScaledRectangle(24, 30 + i * 10, this.field_230712_o_.func_78256_a(((TileEntitySecurityStation)this.te).sharedUsers.get(i).getName()), 8);
            WidgetButtonExtended button = this.getInvisibleButtonFromRectangle("remove:" + i, rect, b -> {});
            button.setInvisibleHoverColor(0x44FF0000);
            button.setVisible(false);
            this.accessStat.addSubWidget((Widget)button);
            this.removeUserButtons.add(button);
            if (!((TileEntitySecurityStation)this.te).sharedUsers.get(i).getName().equals(this.field_230706_i_.field_71439_g.func_146103_bH().getName())) continue;
            button.field_230694_p_ = false;
        }
    }
}

