/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.util.ProgWidgetRenderer;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiUnitProgrammer
extends Screen {
    private static final float SCALE_PER_STEP = 0.2f;
    private final List<IProgWidget> progWidgets;
    private final int guiLeft;
    private final int guiTop;
    private final int startX;
    private final int startY;
    private final int areaWidth;
    private final int areaHeight;
    private final WidgetVerticalScrollbar scaleScroll;
    private double translatedX;
    private double translatedY;
    private int lastZoom;
    private static final float ARROW_ANGLE = (float)Math.toRadians(30.0);
    private static final float ARROW_SIZE = 5.0f;

    public GuiUnitProgrammer(List<IProgWidget> progWidgets, int guiLeft, int guiTop, int width, int height, Rectangle2d bounds, double translatedX, double translatedY, int lastZoom) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"block.pneumaticcraft.programmer", (Object[])new Object[0])));
        this.progWidgets = progWidgets;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.func_231158_b_(Minecraft.func_71410_x(), width, height);
        this.startX = bounds.func_199318_a();
        this.startY = bounds.func_199319_b();
        this.areaWidth = bounds.func_199316_c();
        this.areaHeight = bounds.func_199317_d();
        this.translatedX = translatedX;
        this.translatedY = translatedY;
        this.lastZoom = lastZoom;
        this.scaleScroll = new WidgetVerticalScrollbar(guiLeft + this.areaWidth + 8, guiTop + 40, this.areaHeight - 25).setStates(9).setCurrentState(lastZoom).setListening(true);
    }

    public WidgetVerticalScrollbar getScrollBar() {
        return this.scaleScroll;
    }

    int getLastZoom() {
        return this.lastZoom;
    }

    double getTranslatedX() {
        return this.translatedX;
    }

    double getTranslatedY() {
        return this.translatedY;
    }

    public void renderForeground(MatrixStack matrixStack, int x, int y, IProgWidget tooltipExcludingWidget) {
        IProgWidget progWidget = this.getHoveredWidget(x, y);
        if (progWidget != null && progWidget != tooltipExcludingWidget) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            progWidget.getTooltip(tooltip);
            ArrayList<ITextComponent> errors = new ArrayList<ITextComponent>();
            progWidget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.errors", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE}));
                for (ITextComponent error : errors) {
                    PneumaticCraftUtils.splitString("\u25b6 " + error.getString(), 40).forEach(str -> tooltip.add((ITextComponent)new StringTextComponent(str).func_240699_a_(TextFormatting.RED)));
                }
            }
            ArrayList<ITextComponent> warnings = new ArrayList<ITextComponent>();
            progWidget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() > 0) {
                tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.warnings", new Object[0]).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
                for (ITextComponent warning : warnings) {
                    PneumaticCraftUtils.splitString("\u25b6 " + warning.getString(), 40).forEach(str -> tooltip.add((ITextComponent)new StringTextComponent(str).func_240699_a_(TextFormatting.YELLOW)));
                }
            }
            this.addAdditionalInfoToTooltip(progWidget, tooltip);
            if (!tooltip.isEmpty()) {
                this.func_238654_b_(matrixStack, tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList()), x - this.guiLeft, y - this.guiTop);
            }
        }
    }

    public IProgWidget getHoveredWidget(int mouseX, int mouseY) {
        float scale = this.getScale();
        for (IProgWidget widget : this.progWidgets) {
            if (this.isOutsideProgrammingArea(widget) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft >= (double)widget.getX()) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop >= (double)widget.getY()) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft <= (double)((float)widget.getX() + (float)widget.getWidth() / 2.0f)) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop <= (double)((float)widget.getY() + (float)widget.getHeight() / 2.0f))) continue;
            return widget;
        }
        return null;
    }

    protected void addAdditionalInfoToTooltip(IProgWidget widget, List<ITextComponent> tooltip) {
        if (ProgWidgetGuiManager.hasGui(widget)) {
            tooltip.add((ITextComponent)new StringTextComponent("Right-click for options").func_240699_a_(TextFormatting.GOLD));
        }
        ThirdPartyManager.instance().getDocsProvider().addTooltip(tooltip, false);
    }

    public void render(MatrixStack matrixStack, int x, int y, boolean showFlow, boolean showInfo) {
        if (this.scaleScroll.getState() != this.lastZoom) {
            float shift = 0.2f * (float)(this.scaleScroll.getState() - this.lastZoom);
            float prevScale = 2.0f - (float)this.lastZoom * 0.2f;
            this.translatedX += (double)shift * ((double)x - this.translatedX) / (double)prevScale;
            this.translatedY += (double)shift * ((double)y - this.translatedY) / (double)prevScale;
        }
        this.lastZoom = this.scaleScroll.getState();
        MainWindow mw = this.field_230706_i_.func_228018_at_();
        double sf = mw.func_198100_s();
        GL11.glScissor((int)((int)((double)(this.guiLeft + this.startX) * mw.func_198100_s())), (int)((int)((double)mw.func_198087_p() * sf - (double)this.areaHeight * sf - (double)(this.guiTop + this.startY) * sf)), (int)((int)((double)this.areaWidth * sf)), (int)((int)((double)this.areaHeight * sf)));
        GL11.glEnable((int)3089);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(this.translatedX, this.translatedY, 0.0);
        float scale = this.getScale();
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        if (showFlow) {
            this.showFlow(matrixStack);
        }
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (IProgWidget widget : this.progWidgets) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
            matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget);
            matrixStack.func_227865_b_();
        }
        for (IProgWidget widget : this.progWidgets) {
            ArrayList<ITextComponent> errors = new ArrayList<ITextComponent>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                this.drawBorder(matrixStack, widget, -65536);
                continue;
            }
            ArrayList<ITextComponent> warnings = new ArrayList<ITextComponent>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() <= 0) continue;
            this.drawBorder(matrixStack, widget, -256);
        }
        this.renderAdditionally(matrixStack);
        RenderSystem.disableBlend();
        if (showInfo) {
            for (IProgWidget widget : this.progWidgets) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
                matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
                ProgWidgetRenderer.doExtraRendering2d(matrixStack, widget);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227865_b_();
        GL11.glDisable((int)3089);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (mouseButton == 0 && !this.scaleScroll.isDragging() && new Rectangle2d(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).func_199315_b((int)mouseX, (int)mouseY)) {
            this.translatedX += dx;
            this.translatedY += dy;
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double dir) {
        return this.scaleScroll.func_231043_a_(mouseX, mouseY, dir);
    }

    protected void renderAdditionally(MatrixStack matrixStack) {
    }

    protected void drawBorder(MatrixStack matrixStack, IProgWidget widget, int color) {
        this.drawBorder(matrixStack, widget, color, 0);
    }

    protected void drawBorder(MatrixStack matrixStack, IProgWidget widget, int color, int inset) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        this.func_238473_b_(matrixStack, inset, inset, widget.getHeight() - inset, color);
        this.func_238473_b_(matrixStack, widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        this.func_238465_a_(matrixStack, widget.getWidth() - inset, inset, inset, color);
        this.func_238465_a_(matrixStack, widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        matrixStack.func_227865_b_();
    }

    private void showFlow(MatrixStack matrixStack) {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableTexture();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IJump)) continue;
            for (String jumpLocation : ((IJump)((Object)widget)).getPossibleJumpLocations()) {
                if (jumpLocation == null) continue;
                for (IProgWidget w : this.progWidgets) {
                    if (!(w instanceof ILabel) || !jumpLocation.equals(((ILabel)((Object)w)).getLabel())) continue;
                    int x1 = widget.getX() + widget.getWidth() / 4;
                    int y1 = widget.getY() + widget.getHeight() / 4;
                    int x2 = w.getX() + w.getWidth() / 4;
                    int y2 = w.getY() + w.getHeight() / 4;
                    float midX = (float)(x2 + x1) / 2.0f;
                    float midY = (float)(y2 + y1) / 2.0f;
                    wr.func_227888_a_(posMat, (float)(this.guiLeft + x1), (float)(this.guiTop + y1), 0.0f).func_181675_d();
                    wr.func_227888_a_(posMat, (float)(this.guiLeft + x2), (float)(this.guiTop + y2), 0.0f).func_181675_d();
                    Vector3d arrowVec = new Vector3d((double)(x1 - x2), (double)(y1 - y2), 0.0).func_72432_b();
                    arrowVec = new Vector3d(arrowVec.field_72450_a * 5.0, 0.0, arrowVec.field_72448_b * 5.0);
                    arrowVec = arrowVec.func_178785_b(ARROW_ANGLE);
                    wr.func_227888_a_(posMat, (float)this.guiLeft + midX, (float)this.guiTop + midY, 0.0f).func_181675_d();
                    wr.func_227888_a_(posMat, (float)this.guiLeft + midX + (float)arrowVec.field_72450_a, (float)this.guiTop + midY + (float)arrowVec.field_72449_c, 0.0f).func_181675_d();
                    arrowVec = arrowVec.func_178785_b(-2.0f * ARROW_ANGLE);
                    wr.func_227888_a_(posMat, (float)this.guiLeft + midX, (float)this.guiTop + midY, 0.0f).func_181675_d();
                    wr.func_227888_a_(posMat, (float)this.guiLeft + midX + (float)arrowVec.field_72450_a, (float)this.guiTop + midY + (float)arrowVec.field_72449_c, 0.0f).func_181675_d();
                }
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    public float getScale() {
        return 2.0f - (float)this.scaleScroll.getState() * 0.2f;
    }

    boolean isOutsideProgrammingArea(IProgWidget widget) {
        float scale = this.getScale();
        int x = (int)((float)(widget.getX() + this.guiLeft) * scale);
        int y = (int)((float)(widget.getY() + this.guiTop) * scale);
        x = (int)((double)x + (this.translatedX - (double)this.guiLeft));
        y = (int)((double)y + (this.translatedY - (double)this.guiTop));
        return x < this.startX || (float)x + (float)widget.getWidth() * scale / 2.0f > (float)(this.startX + this.areaWidth) || y < this.startY || (float)y + (float)widget.getHeight() * scale / 2.0f > (float)(this.startY + this.areaHeight);
    }

    public void gotoPiece(IProgWidget widget) {
        if (widget != null) {
            this.scaleScroll.currentScroll = 0.0f;
            this.lastZoom = 0;
            this.translatedX = (double)(-widget.getX()) * 2.0 + (double)this.areaWidth / 2.0 - (double)this.guiLeft;
            this.translatedY = (double)(-widget.getY()) * 2.0 + (double)this.areaHeight / 2.0 - (double)this.guiTop;
        }
    }
}

