/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticScreenBase;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.ITickableWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiMoveStat
extends GuiPneumaticScreenBase {
    private final IGuiAnimatedStat movedStat;
    private final IArmorUpgradeClientHandler renderHandler;
    private boolean clicked = false;
    private final List<IGuiAnimatedStat> otherStats = new ArrayList<IGuiAnimatedStat>();
    private final List<String> helpText = new ArrayList<String>();
    private final ArmorHUDLayout.LayoutTypes layoutItem;
    private WidgetCheckBox snapToGrid;
    private Slider gridSlider;
    private static boolean snap = false;
    private static int gridSize = 4;

    public GuiMoveStat(IArmorUpgradeClientHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem) {
        this(renderHandler, layoutItem, renderHandler.getAnimatedStat());
    }

    public GuiMoveStat(IArmorUpgradeClientHandler renderHandler, ArmorHUDLayout.LayoutTypes layoutItem, @Nonnull IGuiAnimatedStat movedStat) {
        super((ITextComponent)new StringTextComponent("Move Gui"));
        this.movedStat = movedStat;
        this.renderHandler = renderHandler;
        this.layoutItem = layoutItem;
        movedStat.openStat();
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeClientHandler> renderHandlers = ArmorUpgradeClientRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IGuiAnimatedStat stat;
                IArmorUpgradeClientHandler upgradeRenderHandler = renderHandlers.get(i);
                if (!commonArmorHandler.isUpgradeInserted(slot, i) || !commonArmorHandler.isUpgradeEnabled(slot, i) || (stat = upgradeRenderHandler.getAnimatedStat()) == null || stat == movedStat) continue;
                this.otherStats.add(stat);
            }
        }
        CoreComponentsClientHandler mainOptions = HUDHandler.getInstance().getSpecificRenderer(CoreComponentsClientHandler.class);
        if (movedStat != mainOptions.testMessageStat) {
            mainOptions.testMessageStat = new WidgetAnimatedStat(null, (ITextComponent)new StringTextComponent("Test Message, keep in mind messages can be long!"), WidgetAnimatedStat.StatIcon.NONE, 0x7000AA00, null, ArmorHUDLayout.INSTANCE.messageStat);
            mainOptions.testMessageStat.openStat();
            this.otherStats.add(mainOptions.testMessageStat);
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.snapToGrid = new WidgetCheckBox(10, this.field_230709_l_ * 3 / 5, 0xC0C0C0, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.snapToGrid", new Object[0]));
        this.snapToGrid.field_230690_l_ = (this.field_230708_k_ - this.snapToGrid.func_230998_h_()) / 2;
        this.snapToGrid.checked = snap;
        this.func_230480_a_(this.snapToGrid);
        this.gridSlider = new Slider(this.snapToGrid.field_230690_l_, this.snapToGrid.field_230691_m_ + 12, this.snapToGrid.func_230998_h_(), 10, StringTextComponent.field_240750_d_, StringTextComponent.field_240750_d_, 1.0, 12.0, (double)gridSize, false, true, b -> {}, null);
        this.func_230480_a_((Widget)this.gridSlider);
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.movedStat.getBounds().func_199315_b((int)mouseX, (int)mouseY)) {
            if (mouseButton == 2) {
                this.movedStat.setLeftSided(!this.movedStat.isLeftSided());
                this.save();
            } else if (mouseButton < 2) {
                this.clicked = true;
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        if (this.clicked) {
            if (mouseButton == 0 || mouseButton == 1) {
                this.reposition(this.movedStat, mouseX, mouseY);
            }
            this.save();
            this.clicked = false;
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (this.clicked) {
            this.reposition(this.movedStat, mouseX, mouseY);
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, mouseButton, dx, dy);
    }

    private void reposition(IGuiAnimatedStat stat, double x, double y) {
        if (snap) {
            x -= x % (double)gridSize;
            y -= y % (double)gridSize;
        }
        stat.setBaseX((int)x);
        stat.setBaseY((int)y);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a((Screen)GuiArmorMainScreen.getInstance());
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        GuiUtils.showPopupHelpScreen(matrixStack, this, this.field_230712_o_, this.helpText);
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        this.movedStat.renderStat(matrixStack, -1, -1, partialTicks);
        this.otherStats.forEach(stat -> {
            int c = stat.getBackgroundColor();
            stat.setBackgroundColor(0x30606060);
            stat.renderStat(matrixStack, -1, -1, partialTicks);
            stat.setBackgroundColor(c);
        });
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        snap = this.snapToGrid.checked;
        gridSize = this.gridSlider.getValueInt();
        this.gridSlider.field_230694_p_ = snap;
        this.movedStat.tickWidget();
        this.otherStats.forEach(ITickableWidget::tickWidget);
        if (this.helpText.isEmpty()) {
            this.helpText.add(TextFormatting.GREEN + "" + TextFormatting.UNDERLINE + "Moving: " + I18n.func_135052_a((String)ArmorUpgradeRegistry.getStringKey(this.renderHandler.getCommonHandler().getID()), (Object[])new Object[0]));
            this.helpText.add("");
            this.helpText.add("Left- or Right-Click: move the highlighted stat");
            this.helpText.add("...");
        }
        this.helpText.set(3, "Stat expands " + this.getDir(this.movedStat.isLeftSided()) + ". Middle-click: expand " + this.getDir(!this.movedStat.isLeftSided()));
    }

    private String getDir(boolean left) {
        return TextFormatting.YELLOW + (left ? "Left" : "Right") + TextFormatting.RESET;
    }

    private void save() {
        MainWindow sr = this.field_230706_i_.func_228018_at_();
        ArmorHUDLayout.INSTANCE.updateLayout(this.layoutItem, (float)this.movedStat.getBaseX() / (float)sr.func_198107_o(), (float)this.movedStat.getBaseY() / (float)sr.func_198087_p(), this.movedStat.isLeftSided());
    }
}

