/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens;

import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiMoveStat;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.AbstractSliderOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsClientHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class JetBootsOptions
extends AbstractSliderOptions<JetBootsClientHandler> {
    private WidgetKeybindCheckBox checkBox;

    public JetBootsOptions(IGuiScreen screen, JetBootsClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        this.checkBox = WidgetKeybindCheckBox.getOrCreate(PneumaticCraftUtils.RL("jet_boots.module.builder_mode"), 5, 45, -1, b -> this.setBuilderMode(b.checked));
        gui.addWidget(this.checkBox);
        gui.addWidget(new WidgetButtonExtended(30, 128, 150, 20, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.moveStatScreen", new Object[0]), b -> {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiMoveStat((IArmorUpgradeClientHandler)this.getClientUpgradeHandler(), ArmorHUDLayout.LayoutTypes.JET_BOOTS));
        }));
    }

    private void setBuilderMode(boolean enabled) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 3) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("JetBootsBuilderMode", enabled);
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlotType.FEET, tag));
            CommonArmorHandler.getHandlerForPlayer().onDataFieldUpdated("JetBootsBuilderMode", tag.func_74781_a("JetBootsBuilderMode"));
            ResourceLocation id = ((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler().getID();
            HUDHandler.getInstance().addFeatureToggleMessage(ArmorUpgradeRegistry.getStringKey(id), ArmorUpgradeRegistry.getStringKey(this.checkBox.getUpgradeId()), enabled);
        }
    }

    @Override
    public void tick() {
        super.tick();
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
        this.checkBox.field_230693_o_ = handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS) >= 3;
    }

    @Override
    protected String getTagName() {
        return "JetBootsPower";
    }

    @Override
    protected ITextComponent getPrefix() {
        return new StringTextComponent("Power: ");
    }

    @Override
    protected ITextComponent getSuffix() {
        return new StringTextComponent("%");
    }
}

