/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetAnimatedStat
extends Widget
implements IGuiAnimatedStat,
ITooltipProvider {
    private static final int ANIMATED_STAT_SPEED = 30;
    private static final int MIN_WIDTH_HEIGHT = 17;
    private static final int MAX_LINES = 12;
    private static final Pattern DARK_FORMATTING = Pattern.compile("\\u00A7[0123458]");
    private IGuiAnimatedStat affectingStat;
    private StatIcon statIcon;
    private final Screen gui;
    private final List<String> textList = new ArrayList<String>();
    private final List<Widget> subWidgets = new ArrayList<Widget>();
    private int affectedY;
    private int oldBaseX;
    private int oldAffectedY;
    private int oldWidth;
    private int oldHeight;
    private boolean isClicked = false;
    private int minWidth = 17;
    private int minHeight = 17;
    private int backGroundColor;
    private TintColor bgColorHi;
    private TintColor bgColorLo;
    private boolean leftSided;
    private boolean doneExpanding;
    private float textSize;
    private float textScale = 1.0f;
    private int curScroll;
    private int lineSpacing = 10;
    private int widgetOffsetLeft = 0;
    private int widgetOffsetRight = 0;
    private boolean bevel = false;
    private WidgetVerticalScrollbar scrollBar = null;

    public WidgetAnimatedStat(Screen gui, ITextComponent title, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        super(xPos, yPos, 17, 17, title);
        this.gui = gui;
        this.affectingStat = affectingStat;
        this.backGroundColor = backGroundColor;
        this.calculateColorHighlights(this.backGroundColor);
        this.statIcon = StatIcon.NONE;
        this.leftSided = leftSided;
        this.textSize = 1.0f;
        this.affectedY = this.field_230691_m_;
        if (affectingStat != null) {
            this.affectedY += affectingStat.getAffectedY() + affectingStat.getStatHeight();
        }
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor) {
        this(gui, StringTextComponent.field_240750_d_, 0, 0, backgroundColor, null, false);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, ItemStack icon) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(icon);
    }

    public WidgetAnimatedStat(Screen gui, int backgroundColor, String texture) {
        this(gui, backgroundColor);
        this.statIcon = StatIcon.of(PneumaticCraftUtils.RL(texture));
    }

    public WidgetAnimatedStat(Screen gui, ITextComponent title, StatIcon icon, int xPos, int yPos, int backGroundColor, IGuiAnimatedStat affectingStat, boolean leftSided) {
        this(gui, title, xPos, yPos, backGroundColor, affectingStat, leftSided);
        this.statIcon = icon;
    }

    public WidgetAnimatedStat(Screen gui, ITextComponent title, StatIcon icon, int backGroundColor, IGuiAnimatedStat affectingStat, ArmorHUDLayout.LayoutItem layout) {
        this(gui, title, 0, 0, backGroundColor, affectingStat, layout.isLeftSided());
        MainWindow mw = Minecraft.func_71410_x().func_228018_at_();
        int x = layout.getX() == -1.0f ? mw.func_198107_o() - 2 : (int)((float)mw.func_198107_o() * layout.getX());
        this.setBaseX(x);
        this.setBaseY((int)((float)mw.func_198087_p() * layout.getY()));
        this.statIcon = icon;
    }

    @Override
    public void setParentStat(IGuiAnimatedStat stat) {
        this.affectingStat = stat;
    }

    public void addSubWidget(Widget widget) {
        this.subWidgets.add(widget);
    }

    public void removeSubWidget(Widget widget) {
        this.subWidgets.remove(widget);
    }

    public void setWidgetOffsets(int left, int right) {
        this.widgetOffsetLeft = left;
        this.widgetOffsetRight = right;
    }

    @Override
    public Rectangle2d getButtonScaledRectangle(int origX, int origY, int width, int height) {
        int scaledX = (int)((float)origX * this.textSize);
        int scaledY = (int)((float)origY * this.textSize);
        return new Rectangle2d(scaledX, scaledY, (int)((float)width * this.textSize), (int)((float)height * this.textSize));
    }

    @Override
    public void scaleTextSize(float scale) {
        this.textSize *= scale;
        this.textScale = scale;
        this.subWidgets.removeIf(w -> w == this.scrollBar);
        this.scrollBar = null;
        this.onTextChange();
    }

    @Override
    public boolean isLeftSided() {
        return this.leftSided;
    }

    @Override
    public void setLeftSided(boolean leftSided) {
        this.leftSided = leftSided;
    }

    @Override
    public IGuiAnimatedStat setText(List<String> text) {
        this.textList.clear();
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(25.0f / this.textScale)));
        }
        this.onTextChange();
        return this;
    }

    @Override
    public IGuiAnimatedStat setText(String text) {
        this.textList.clear();
        this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)text, (Object[])new Object[0]), (int)(25.0f / this.textScale)));
        this.onTextChange();
        return this;
    }

    @Override
    public void setTextWithoutCuttingString(List<String> text) {
        this.textList.clear();
        this.textList.addAll(text);
        this.onTextChange();
    }

    @Override
    public void appendText(List<String> text) {
        for (String line : text) {
            this.textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)line, (Object[])new Object[0]), (int)(45.0f / this.textScale)));
        }
        this.onTextChange();
    }

    @Override
    public void addPadding(int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        this.setTextWithoutCuttingString(IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList()));
    }

    @Override
    public void addPadding(List<String> text, int nRows, int nCols) {
        String s = Strings.repeat((String)" ", (int)nCols);
        List<String> l = IntStream.range(0, nRows).mapToObj(i -> s).collect(Collectors.toList());
        for (int i2 = 0; i2 < text.size() && i2 < nRows; ++i2) {
            l.set(i2, text.get(i2));
        }
        this.setTextWithoutCuttingString(l);
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.backGroundColor) {
            this.backGroundColor = backgroundColor;
            this.calculateColorHighlights(backgroundColor);
        }
    }

    @Override
    public int getBackgroundColor() {
        return this.backGroundColor;
    }

    private void calculateColorHighlights(int color) {
        if (PNCConfig.Client.guiBevel) {
            float fgR = (float)(color >> 16 & 0xFF) / 255.0f;
            float fgG = (float)(color >> 8 & 0xFF) / 255.0f;
            float fgB = (float)(color & 0xFF) / 255.0f;
            float fgA = (float)(color >> 24 & 0xFF) / 255.0f;
            TintColor c = new TintColor(fgR, fgG, fgB, fgA);
            if (this.bevel) {
                this.bgColorHi = c.brighter();
                this.bgColorLo = c.darker();
            } else {
                this.bgColorLo = this.bgColorHi = c.darker().darker();
            }
        } else {
            this.bgColorLo = this.bgColorHi = TintColor.BLACK;
        }
    }

    @Override
    public void setBeveled(boolean bevel) {
        this.bevel = bevel;
        this.calculateColorHighlights(this.backGroundColor);
    }

    private void onTextChange() {
        if (this.textList.size() > 12) {
            for (Widget widget : this.subWidgets) {
                if (widget != this.scrollBar) continue;
                return;
            }
            this.curScroll = 0;
            int h = (int)((float)(12 * this.lineSpacing - 20) * this.textSize);
            this.scrollBar = new WidgetVerticalScrollbar(this.leftSided ? -16 : 2, 20, h).setStates(this.textList.size() - 12).setListening(true);
            this.addSubWidget(this.scrollBar);
        } else {
            Iterator<Widget> iterator = this.subWidgets.iterator();
            while (iterator.hasNext()) {
                Widget widget = iterator.next();
                if (widget != this.scrollBar) continue;
                iterator.remove();
                this.curScroll = 0;
            }
        }
    }

    @Override
    public void setMinDimensionsAndReset(int minWidth, int minHeight) {
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.field_230688_j_ = minWidth;
        this.field_230689_k_ = minHeight;
    }

    @Override
    public void tickWidget() {
        this.oldBaseX = this.field_230690_l_;
        this.oldAffectedY = this.affectedY;
        this.oldWidth = this.field_230688_j_;
        this.oldHeight = this.field_230689_k_;
        this.doneExpanding = true;
        if (this.isClicked) {
            Pair<Integer, Integer> maxSize = this.calculateMaxSize();
            int maxWidth = (Integer)maxSize.getLeft();
            int maxHeight = (Integer)maxSize.getRight();
            this.field_230688_j_ = Math.min(maxWidth, this.field_230688_j_ + 30);
            this.field_230689_k_ = Math.min(maxHeight, this.field_230689_k_ + 30);
            this.doneExpanding = this.field_230688_j_ == maxWidth && this.field_230689_k_ == maxHeight;
            int scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            int scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
            if (this.isLeftSided()) {
                if (this.field_230690_l_ >= scaledWidth) {
                    this.field_230690_l_ = scaledWidth;
                }
            } else if (this.field_230690_l_ < 0) {
                this.field_230690_l_ = 1;
            }
            if (this.field_230691_m_ + this.field_230689_k_ >= scaledHeight) {
                this.field_230691_m_ = scaledHeight - this.field_230689_k_ - 1;
            }
            if (this.doneExpanding) {
                for (Widget widget : this.subWidgets) {
                    if (widget != this.scrollBar) continue;
                    this.curScroll = ((WidgetVerticalScrollbar)widget).getState();
                    break;
                }
            }
        } else {
            this.field_230688_j_ = Math.max(this.minWidth, this.field_230688_j_ - 30);
            this.field_230689_k_ = Math.max(this.minHeight, this.field_230689_k_ - 30);
            this.doneExpanding = false;
        }
        this.affectedY = this.field_230691_m_;
        if (this.affectingStat != null) {
            this.affectedY += this.affectingStat.getAffectedY() + this.affectingStat.getStatHeight();
        }
    }

    private Pair<Integer, Integer> calculateMaxSize() {
        int maxHeight;
        int availableWidth;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (this.gui instanceof ContainerScreen) {
            ContainerScreen gc = (ContainerScreen)this.gui;
            availableWidth = this.leftSided ? gc.getGuiLeft() : gc.field_230708_k_ - (gc.getGuiLeft() + gc.getXSize());
        } else {
            availableWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        }
        int maxWidth = fontRenderer.func_78256_a(this.func_230458_i_().getString());
        for (String line : this.textList) {
            maxWidth = Math.max(maxWidth, fontRenderer.func_78256_a(line));
        }
        maxWidth += 20;
        int n = maxHeight = this.func_230458_i_().getString().isEmpty() ? 6 : 16;
        if (!this.textList.isEmpty()) {
            maxHeight += Math.min(12, this.textList.size()) * this.lineSpacing;
        }
        fontRenderer.getClass();
        maxHeight -= this.lineSpacing - 9;
        float lastTextSize = this.textSize;
        if (maxWidth > availableWidth - 3) {
            this.textSize = ((float)availableWidth - 3.0f) / (float)maxWidth;
            maxWidth = (int)((float)maxWidth * this.textSize);
            maxHeight = (int)((float)maxHeight * this.textSize);
        } else {
            this.textSize = 1.0f;
        }
        if (lastTextSize != this.textSize) {
            float newTextSize = this.textSize;
            this.textSize = 1.0f;
            this.scaleTextSize(newTextSize);
        }
        return Pair.of((Object)maxWidth, (Object)maxHeight);
    }

    @Override
    public void renderStat(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230431_b_(matrixStack, x, y, partialTicks);
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        if (this.leftSided) {
            return this.field_230693_o_ && this.field_230694_p_ && mouseX >= (double)this.field_230690_l_ - (double)this.field_230688_j_ && mouseX < (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        }
        return super.func_230992_c_(mouseX, mouseY);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        String title;
        int titleYoffset;
        if (!this.field_230694_p_) {
            return;
        }
        int baseX = this.leftSided ? this.field_230690_l_ - this.field_230688_j_ : this.field_230690_l_;
        this.field_230692_n_ = mouseX >= baseX && mouseY >= this.affectedY && mouseX < baseX + this.field_230688_j_ && mouseY < this.affectedY + this.field_230689_k_;
        float zLevel = 0.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.field_230690_l_ - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.field_230688_j_ - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.field_230689_k_ - this.oldHeight) * partialTicks);
        if (this.leftSided) {
            renderWidth *= -1;
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)renderBaseX, (int)renderAffectedY, (int)(renderBaseX + renderWidth), (int)(renderAffectedY + renderHeight), (int)this.backGroundColor);
        RenderSystem.disableTexture();
        RenderSystem.lineWidth((float)3.0f);
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
        float[] c2 = this.bgColorHi.getComponents(null);
        float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
        float[] c4 = this.bgColorLo.getComponents(null);
        wr.func_225582_a_((double)renderBaseX, (double)renderAffectedY, (double)zLevel).func_227885_a_(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
        wr.func_225582_a_((double)(renderBaseX + renderWidth), (double)renderAffectedY, (double)zLevel).func_227885_a_(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
        wr.func_225582_a_((double)(renderBaseX + renderWidth), (double)(renderAffectedY + renderHeight), (double)zLevel).func_227885_a_(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
        wr.func_225582_a_((double)renderBaseX, (double)(renderAffectedY + renderHeight), (double)zLevel).func_227885_a_(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        if (this.leftSided) {
            renderWidth *= -1;
        }
        int n = titleYoffset = (title = this.func_230458_i_().getString()).isEmpty() ? 3 : 12;
        if (this.doneExpanding) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, 0.0);
            matrixStack.func_227862_a_(this.textSize, this.textSize, this.textSize);
            matrixStack.func_227861_a_((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), 0.0);
            if (!title.isEmpty()) {
                fontRenderer.func_238405_a_(matrixStack, title, (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + 2), 0xFFFF00);
            }
            for (int i = this.curScroll; i < this.textList.size() && i < this.curScroll + 12; ++i) {
                if (DARK_FORMATTING.matcher(this.textList.get(i)).find()) {
                    fontRenderer.func_238421_b_(matrixStack, this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset), 0xFFFFFF);
                    continue;
                }
                fontRenderer.func_238405_a_(matrixStack, this.textList.get(i), (float)(renderBaseX + (this.leftSided ? -renderWidth + 2 : 18)), (float)(renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset), 0xFFFFFF);
            }
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderAffectedY + (titleYoffset - 10)), 0.0);
            RenderSystem.enableTexture();
            this.subWidgets.forEach(widget -> widget.func_230430_a_(matrixStack, mouseX - renderBaseX, mouseY - renderAffectedY, partialTicks));
            matrixStack.func_227865_b_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render(matrixStack, renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    public void render3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        int renderBaseX = (int)((float)this.oldBaseX + (float)(this.field_230690_l_ - this.oldBaseX) * partialTicks);
        int renderAffectedY = (int)((float)this.oldAffectedY + (float)(this.affectedY - this.oldAffectedY) * partialTicks);
        int renderWidth = (int)((float)this.oldWidth + (float)(this.field_230688_j_ - this.oldWidth) * partialTicks);
        int renderHeight = (int)((float)this.oldHeight + (float)(this.field_230689_k_ - this.oldHeight) * partialTicks);
        int[] cols = RenderUtils.decomposeColor(this.backGroundColor);
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getUntexturedQuad(true), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderAffectedY + (float)renderHeight, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX + (float)rw, (float)renderAffectedY + (float)renderHeight, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX + (float)rw, (float)renderAffectedY, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderAffectedY, 0.0f).func_225586_a_(cols[1], cols[2], cols[3], cols[0]).func_227886_a_(0xF000F0).func_181675_d();
        });
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoopsTransparent(5.0), (posMat, builder) -> {
            int rw = this.leftSided ? -renderWidth : renderWidth;
            float[] c1 = this.leftSided ? this.bgColorLo.getComponents(null) : this.bgColorHi.getComponents(null);
            float[] c2 = this.bgColorHi.getComponents(null);
            float[] c3 = this.leftSided ? this.bgColorHi.getComponents(null) : this.bgColorLo.getComponents(null);
            float[] c4 = this.bgColorLo.getComponents(null);
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)renderAffectedY, 0.0f).func_227885_a_(c1[0], c1[1], c1[2], c1[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)(renderBaseX + rw), (float)renderAffectedY, 0.0f).func_227885_a_(c2[0], c2[1], c2[2], c2[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)(renderBaseX + rw), (float)(renderAffectedY + renderHeight), 0.0f).func_227885_a_(c3[0], c3[1], c3[2], c3[3]).func_181675_d();
            builder.func_227888_a_(posMat, (float)renderBaseX, (float)(renderAffectedY + renderHeight), 0.0f).func_227885_a_(c4[0], c4[1], c4[2], c4[3]).func_181675_d();
        });
        if (this.doneExpanding) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? -renderWidth : 16)), (double)renderAffectedY, 0.0);
            matrixStack.func_227862_a_(this.textSize, this.textSize, this.textSize);
            matrixStack.func_227861_a_((double)(-renderBaseX - (this.leftSided ? -renderWidth : 16)), (double)(-renderAffectedY), 0.0);
            String title = this.func_230458_i_().getString();
            if (!title.isEmpty()) {
                RenderUtils.renderString3d(TextFormatting.BOLD + title, renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + 2, -256, matrixStack, buffer, false, true);
            }
            int titleYoffset = title.isEmpty() ? 3 : 12;
            for (int i = this.curScroll; i < this.textList.size() && i < this.curScroll + 12; ++i) {
                if (DARK_FORMATTING.matcher(this.textList.get(i)).find()) {
                    RenderUtils.renderString3d(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset, 0xFFFFFF, matrixStack, buffer, false, true);
                    continue;
                }
                RenderUtils.renderString3d(this.textList.get(i), renderBaseX + (this.leftSided ? -renderWidth + 2 : 18), renderAffectedY + (i - this.curScroll) * this.lineSpacing + titleYoffset, 0xFFFFFF, matrixStack, buffer, false, true);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(renderBaseX + (this.leftSided ? this.widgetOffsetLeft : this.widgetOffsetRight)), (double)(renderAffectedY + (titleYoffset - 10)), 0.0);
            this.subWidgets.stream().filter(widget -> widget instanceof ICanRender3d).forEach(widget -> ((ICanRender3d)widget).render3d(matrixStack, buffer, partialTicks));
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        }
        if (renderHeight > 16 && renderWidth > 16 && this.statIcon != null) {
            this.statIcon.render3d(matrixStack, buffer, renderBaseX, renderAffectedY, this.leftSided);
        }
    }

    private void toggle() {
        boolean bl = this.isClicked = !this.isClicked;
        if (this.isClicked && this.gui instanceof GuiPneumaticContainerBase) {
            List<IGuiAnimatedStat> widgets = ((GuiPneumaticContainerBase)this.gui).getStatWidgets();
            widgets.stream().filter(stat -> this != stat && stat.isLeftSided() == this.isLeftSided()).forEach(IGuiAnimatedStat::closeStat);
            for (Widget w : this.subWidgets) {
                if (!(w instanceof TextFieldWidget)) continue;
                ((TextFieldWidget)w).func_146195_b(true);
            }
        }
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return this.field_230693_o_ && this.field_230694_p_ && this.getBounds().func_199315_b((int)mouseX, (int)mouseY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_230449_g_()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231044_a_(mouseX - (double)this.field_230690_l_, mouseY - (double)this.affectedY, button)) continue;
                return true;
            }
            this.toggle();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.func_230449_g_()) {
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231048_c_(mouseX - (double)this.field_230690_l_, mouseY - (double)this.affectedY, button)) continue;
                return true;
            }
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.func_230449_g_()) {
            Rectangle2d bounds = this.getBounds();
            for (Widget widget : this.subWidgets) {
                if (!widget.func_231045_a_(mouseX - (double)bounds.func_199318_a(), mouseY - (double)bounds.func_199319_b(), button, dragX, dragY)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double x, double y, double dir) {
        Rectangle2d bounds = this.getBounds();
        for (Widget widget : this.subWidgets) {
            if (!widget.func_231043_a_(x - (double)bounds.func_199318_a(), y - (double)bounds.func_199319_b(), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.subWidgets) {
            if (!widget.func_231046_a_(keyCode, scanCode, modifiers) && (!(widget instanceof TextFieldWidget) || !widget.func_230999_j_() || keyCode == 256)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        for (Widget widget : this.subWidgets) {
            if (!widget.func_231042_a_(p_charTyped_1_, p_charTyped_2_)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeStat() {
        this.isClicked = false;
    }

    @Override
    public void openStat() {
        this.isClicked = true;
    }

    @Override
    public boolean isStatOpen() {
        return this.isClicked;
    }

    @Override
    public int getAffectedY() {
        return this.affectedY;
    }

    @Override
    public int getBaseX() {
        return this.field_230690_l_;
    }

    @Override
    public int getBaseY() {
        return this.field_230691_m_;
    }

    @Override
    public int getStatHeight() {
        return this.func_238483_d_();
    }

    @Override
    public int getStatWidth() {
        return this.func_230998_h_();
    }

    public int func_238483_d_() {
        return this.field_230689_k_;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    @Override
    public void setBaseY(int y) {
        this.field_230691_m_ = y;
    }

    @Override
    public boolean isDoneExpanding() {
        return this.doneExpanding;
    }

    @Override
    public void setBaseX(int x) {
        this.field_230690_l_ = x;
    }

    @Override
    public Rectangle2d getBounds() {
        return new Rectangle2d(this.field_230690_l_ - (this.leftSided ? this.field_230688_j_ : 0), this.affectedY, this.field_230688_j_, this.field_230689_k_);
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTooltip, boolean shiftPressed) {
        if (this.mouseIsHoveringOverIcon(mouseX, mouseY)) {
            curTooltip.add(this.func_230458_i_());
        }
        for (Widget widget : this.subWidgets) {
            if (!widget.func_230449_g_() || !(widget instanceof ITooltipProvider)) continue;
            ((ITooltipProvider)widget).addTooltip(mouseX, mouseY, curTooltip, shiftPressed);
        }
    }

    private boolean mouseIsHoveringOverIcon(double x, double y) {
        if (this.leftSided) {
            return x <= (double)this.field_230690_l_ && x >= (double)(this.field_230690_l_ - 16) && y >= (double)this.affectedY && y <= (double)(this.affectedY + 16);
        }
        return x >= (double)this.field_230690_l_ && x <= (double)(this.field_230690_l_ + 16) && y >= (double)this.affectedY && y <= (double)(this.affectedY + 16);
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setTexture(ResourceLocation texture) {
        this.statIcon = StatIcon.of(texture);
    }

    public void setTexture(ItemStack itemStack) {
        this.statIcon = StatIcon.of(itemStack);
    }

    public static class StatIcon {
        public static final StatIcon NONE = new StatIcon(ItemStack.field_190927_a, null);
        private final ItemStack stack;
        private final ResourceLocation texture;

        private StatIcon(ItemStack stack, ResourceLocation texture) {
            this.stack = stack;
            this.texture = texture;
        }

        public static StatIcon of(ItemStack stack) {
            return new StatIcon(stack, null);
        }

        public static StatIcon of(Item item) {
            return new StatIcon(new ItemStack((IItemProvider)item, 1), null);
        }

        public static StatIcon of(ResourceLocation texture) {
            return new StatIcon(ItemStack.field_190927_a, texture);
        }

        void render(MatrixStack matrixStack, int x, int y, boolean leftSided) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            if (this.texture != null) {
                GuiUtils.drawTexture(matrixStack, this.texture, x - (leftSided ? 16 : 0), y);
            } else if (!this.stack.func_190926_b()) {
                GuiUtils.renderItemStack(matrixStack, this.stack, x - (leftSided ? 16 : 0), y);
            }
            RenderSystem.disableBlend();
        }

        public void render3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, int x, int y, boolean leftSided) {
            if (this.texture != null) {
                RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(this.texture), (posMat, builder) -> RenderUtils.drawTexture(matrixStack, builder, x, y, 0xF000F0));
            } else {
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                IBakedModel ibakedmodel = itemRenderer.func_184393_a(this.stack, ClientUtils.getClientWorld(), null);
                itemRenderer.func_229111_a_(this.stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStack, buffer, 0xF000F0, OverlayTexture.field_229196_a_, ibakedmodel);
            }
        }
    }
}

