/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.DyeColor;

public class WidgetColorSelector
extends WidgetButtonExtended
implements IDrawAfterRender {
    private boolean expanded = false;
    private DyeColor color = DyeColor.WHITE;
    private final Rectangle2d mainArea;
    private final Rectangle2d expandedArea;
    private final Consumer<WidgetColorSelector> callback;

    public WidgetColorSelector(int xIn, int yIn) {
        this(xIn, yIn, null);
    }

    public WidgetColorSelector(int xIn, int yIn, Consumer<WidgetColorSelector> callback) {
        super(xIn, yIn, 16, 16, "");
        this.mainArea = new Rectangle2d(xIn, yIn, this.field_230688_j_, this.field_230689_k_);
        this.expandedArea = new Rectangle2d(xIn, yIn + this.field_230689_k_, this.field_230688_j_ * 4, this.field_230689_k_ * 4);
        this.callback = callback;
    }

    public WidgetColorSelector withInitialColor(DyeColor color) {
        this.color = color;
        return this;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        super.func_230431_b_(matrixStack, mouseX, mouseY, partialTick);
        WidgetColorSelector.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + 3), (int)(this.field_230690_l_ + this.field_230688_j_ - 4), (int)(this.field_230691_m_ + this.field_230689_k_ - 4), (int)(0xFF000000 | this.color.getColorValue()));
        this.func_238465_a_(matrixStack, this.field_230690_l_ + 3, this.field_230690_l_ + this.field_230688_j_ - 3, this.field_230691_m_ + this.field_230689_k_ - 4, -10461088);
        this.func_238473_b_(matrixStack, this.field_230690_l_ + this.field_230688_j_ - 4, this.field_230691_m_ + 3, this.field_230691_m_ + this.field_230689_k_ - 3, -10461088);
    }

    @Override
    public void renderAfterEverythingElse(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.expanded) {
            WidgetColorSelector.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ - 1 + this.field_230689_k_), (int)(this.field_230690_l_ + this.field_230688_j_ * 4), (int)(this.field_230691_m_ - 1 + this.field_230689_k_ * 5), (int)-16777216);
            WidgetColorSelector.func_238467_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(this.field_230690_l_ + this.field_230688_j_ * 4 - 1), (int)(this.field_230691_m_ - 2 + this.field_230689_k_ * 5), (int)-8355712);
            for (DyeColor color : DyeColor.values()) {
                int dx = this.field_230690_l_ + color.func_196059_a() % 4 * 16;
                int dy = this.field_230691_m_ - 1 + this.field_230689_k_ + color.func_196059_a() / 4 * 16;
                WidgetColorSelector.func_238467_a_((MatrixStack)matrixStack, (int)(dx + 3), (int)(dy + 3), (int)(dx + 13), (int)(dy + 13), (int)(0xFF000000 | color.getColorValue()));
                this.func_238465_a_(matrixStack, dx + 3, dx + 13, dy + 13, -10461088);
                this.func_238473_b_(matrixStack, dx + 13, dy + 3, dy + 13, -10461088);
            }
        }
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        return super.func_230992_c_(mouseX, mouseY) || this.expanded && this.expandedArea.func_199315_b((int)mouseX, (int)mouseY);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.mainArea.func_199315_b((int)mouseX, (int)mouseY)) {
            this.expanded = !this.expanded;
        } else if (this.expandedArea.func_199315_b((int)mouseX, (int)mouseY)) {
            int dx = (int)mouseX - this.expandedArea.func_199318_a();
            int dy = (int)mouseY - this.expandedArea.func_199319_b();
            int id = dx / 16 + dy / 16 * 4;
            this.color = DyeColor.func_196056_a((int)id);
            boolean bl = this.expanded = !this.expanded;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }
}

