/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetKeybindCheckBox
extends WidgetCheckBox
implements ITooltipProvider {
    private static WidgetKeybindCheckBox coreComponents;
    private final ResourceLocation upgradeID;
    private boolean isAwaitingKey;
    private ITextComponent oldCheckboxText;
    private KeyBinding keyBinding;

    private WidgetKeybindCheckBox(ResourceLocation upgradeID, int x, int y, int color, Consumer<WidgetCheckBox> pressable) {
        super(x, y, color, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.enableModule", PneumaticCraftUtils.xlate(ArmorUpgradeRegistry.getStringKey(upgradeID), new Object[0])), pressable);
        this.upgradeID = upgradeID;
        this.keyBinding = this.findSavedKeybind();
    }

    public static WidgetKeybindCheckBox getOrCreate(ResourceLocation upgradeID, int x, int y, int color, Consumer<WidgetCheckBox> pressable) {
        WidgetKeybindCheckBox newCheckBox = (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(upgradeID);
        if (newCheckBox == null) {
            newCheckBox = new WidgetKeybindCheckBox(upgradeID, x, y, color, pressable);
            newCheckBox.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled(upgradeID);
            if (newCheckBox.keyBinding != null) {
                KeyDispatcher.addKeybind(newCheckBox.keyBinding, newCheckBox);
            }
            KeyDispatcher.id2checkBox.put(upgradeID, newCheckBox);
            if (upgradeID.equals((Object)ArmorUpgradeRegistry.getInstance().coreComponentsHandler.getID())) {
                coreComponents = newCheckBox;
            }
        }
        return newCheckBox;
    }

    public static WidgetKeybindCheckBox get(ResourceLocation upgradeID) {
        return (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(upgradeID);
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeHandler handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeClientHandler handler) {
        return WidgetKeybindCheckBox.get(handler.getCommonHandler().getID());
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    public static boolean isHandlerEnabled(IArmorUpgradeHandler handler) {
        return WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeHandler)handler).checked;
    }

    private KeyBinding makeKeyBinding(int keyCode, KeyModifier modifier) {
        return new KeyBinding(ArmorUpgradeRegistry.getStringKey(this.upgradeID), (IKeyConflictContext)KeyConflictContext.IN_GAME, modifier, InputMappings.Type.KEYSYM, keyCode, "key.pneumaticcraft.category");
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.func_230992_c_(x, y)) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.handleClick(x, y, button);
            return true;
        }
        return false;
    }

    private void handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            super.func_230982_a_(mouseX, mouseY);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ((WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get((Object)this.upgradeID)).checked = this.checked;
            try {
                ArmorFeatureStatus.INSTANCE.writeToFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                int i;
                List<IArmorUpgradeHandler> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
                for (i = 0; i < upgradeHandlers.size(); ++i) {
                    IArmorUpgradeHandler upgradeHandler = upgradeHandlers.get(i);
                    if (!upgradeHandler.getID().equals((Object)this.upgradeID) || !commonArmorHandler.isUpgradeInserted(slot, i)) continue;
                    NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, WidgetKeybindCheckBox.coreComponents.checked && this.checked, slot));
                    commonArmorHandler.setUpgradeEnabled(slot, (byte)i, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
                    HUDHandler.getInstance().addFeatureToggleMessage(ArmorUpgradeRegistry.getStringKey(this.upgradeID), this.checked);
                    break;
                }
                if (!this.upgradeID.equals((Object)ArmorUpgradeRegistry.getInstance().coreComponentsHandler.getID())) continue;
                for (i = 0; i < upgradeHandlers.size(); ++i) {
                    boolean state = WidgetKeybindCheckBox.forUpgrade((IArmorUpgradeHandler)upgradeHandlers.get((int)i)).checked;
                    NetworkHandler.sendToServer(new PacketToggleArmorFeature((byte)i, WidgetKeybindCheckBox.coreComponents.checked && state, slot));
                    commonArmorHandler.setUpgradeEnabled(slot, (byte)i, WidgetKeybindCheckBox.coreComponents.checked && state);
                }
            }
        } else if (button == 1) {
            if (Screen.func_231173_s_()) {
                this.clearKeybinding();
            } else {
                boolean bl = this.isAwaitingKey = !this.isAwaitingKey;
                if (this.isAwaitingKey) {
                    this.oldCheckboxText = this.func_230458_i_();
                    this.func_238482_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]));
                } else {
                    this.func_238482_a_(this.oldCheckboxText);
                }
            }
        }
    }

    private void clearKeybinding() {
        if (this.keyBinding != null) {
            KeyDispatcher.removeKeybind(this.keyBinding);
        }
        KeyBinding[] keyBindings = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        HashSet<Integer> idx = new HashSet<Integer>();
        for (int i = 0; i < keyBindings.length; ++i) {
            if (!keyBindings[i].func_151464_g().equals(this.keyBinding.func_151464_g())) continue;
            idx.add(i);
            break;
        }
        if (!idx.isEmpty()) {
            ArrayList<KeyBinding> l = new ArrayList<KeyBinding>(keyBindings.length);
            for (int i = 0; i < keyBindings.length; ++i) {
                if (idx.contains(i)) continue;
                l.add(keyBindings[i]);
            }
            Minecraft.func_71410_x().field_71474_y.field_74324_K = l.toArray(new KeyBinding[0]);
            this.keyBinding = this.makeKeyBinding(-1, KeyModifier.NONE);
            ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
            KeyBinding.func_74508_b();
            String keybindName = ArmorUpgradeRegistry.getStringKey(this.upgradeID);
            ClientSetup.keybindToKeyCodes.put(keybindName, (Pair<Integer, KeyModifier>)Pair.of((Object)-1, (Object)KeyModifier.NONE));
            Minecraft.func_71410_x().field_71474_y.func_74303_b();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.isAwaitingKey) {
            InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(keyCode);
            if (!KeyModifier.isKeyCodeModifier((InputMappings.Input)input)) {
                this.isAwaitingKey = false;
                this.keyBinding = this.setOrAddKeybind(keyCode, KeyModifier.getActiveModifier());
                KeyDispatcher.cleanupKeybind(this.upgradeID);
                KeyDispatcher.addKeybind(this.keyBinding, (WidgetKeybindCheckBox)KeyDispatcher.id2checkBox.get(this.upgradeID));
                this.func_238482_a_(this.oldCheckboxText);
            }
            return true;
        }
        return false;
    }

    private KeyBinding findSavedKeybind() {
        return this.setOrAddKeybind(-1, KeyModifier.NONE);
    }

    private KeyBinding setOrAddKeybind(int keyCode, KeyModifier modifier) {
        String keybindName = ArmorUpgradeRegistry.getStringKey(this.upgradeID);
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        for (KeyBinding keyBinding : gameSettings.field_74324_K) {
            if (keyBinding == null || !keyBinding.func_151464_g().equals(keybindName)) continue;
            if (keyCode >= 0) {
                keyBinding.setKeyModifierAndCode(modifier, InputMappings.Type.KEYSYM.func_197944_a(keyCode));
                KeyBinding.func_74508_b();
                gameSettings.func_74303_b();
            }
            return keyBinding;
        }
        if (keyCode < 0) {
            if (ClientSetup.keybindToKeyCodes.containsKey(keybindName)) {
                Pair<Integer, KeyModifier> binding = ClientSetup.keybindToKeyCodes.get(keybindName);
                keyCode = (Integer)binding.getLeft();
                modifier = (KeyModifier)binding.getRight();
            } else {
                return null;
            }
        }
        KeyBinding keyBinding = this.makeKeyBinding(keyCode, modifier);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        KeyBinding.func_74508_b();
        gameSettings.func_74303_b();
        return keyBinding;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTooltip, boolean shiftPressed) {
        if (this.keyBinding != null) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", TextFormatting.YELLOW + ClientUtils.translateKeyBind(this.keyBinding)));
        }
        if (!this.isAwaitingKey) {
            curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindRightClickToSet", new Object[0]));
            if (this.keyBinding != null && this.keyBinding.getKey().func_197937_c() != -1) {
                curTooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindShiftRightClickToClear", new Object[0]));
            }
        }
    }

    public ResourceLocation getUpgradeId() {
        return this.upgradeID;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<ResourceLocation, WidgetKeybindCheckBox> id2checkBox = new HashMap<ResourceLocation, WidgetKeybindCheckBox>();
        private static final Map<String, WidgetKeybindCheckBox> dispatchMap = new HashMap<String, WidgetKeybindCheckBox>();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.KeyInputEvent event) {
            WidgetKeybindCheckBox cb;
            if (Minecraft.func_71410_x().field_71462_r == null && event.getAction() == 1 && (cb = dispatchMap.get(event.getKey() + "/" + event.getModifiers())) != null) {
                cb.handleClick(0.0, 0.0, 0);
            }
        }

        static void addKeybind(KeyBinding keyBinding, WidgetKeybindCheckBox widget) {
            String key = keyBinding.getKey().func_197937_c() + "/" + KeyDispatcher.keyModifierToInt(keyBinding.getKeyModifier());
            dispatchMap.put(key, widget);
        }

        static void removeKeybind(KeyBinding keyBinding) {
            String key = keyBinding.getKey().func_197937_c() + "/" + KeyDispatcher.keyModifierToInt(keyBinding.getKeyModifier());
            dispatchMap.remove(key);
        }

        static void cleanupKeybind(ResourceLocation upgradeID) {
            dispatchMap.values().removeIf(w -> ((WidgetKeybindCheckBox)w).upgradeID.equals((Object)upgradeID));
        }

        private static int keyModifierToInt(KeyModifier km) {
            switch (km) {
                case SHIFT: {
                    return 1;
                }
                case CONTROL: {
                    return 2;
                }
                case ALT: {
                    return 4;
                }
            }
            return 0;
        }
    }
}

