/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.commons.lang3.Validate;

public class WidgetRadioButton
extends Widget
implements ITooltipProvider {
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    public boolean checked;
    public boolean enabled = true;
    public final int color;
    private final Consumer<WidgetRadioButton> pressable;
    private final FontRenderer fontRenderer;
    private List<ITextComponent> tooltip;
    public List<WidgetRadioButton> otherChoices;
    private static final float N_POINTS = 12.0f;

    public WidgetRadioButton(int x, int y, int color, ITextComponent text, Consumer<WidgetRadioButton> pressable) {
        super(x, y, 10, 10, text);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.tooltip = new ArrayList<ITextComponent>();
        this.field_230688_j_ = 10 + this.fontRenderer.func_238414_a_((ITextProperties)this.func_230458_i_());
        this.field_230689_k_ = 10;
        this.color = color;
        this.pressable = pressable;
    }

    public WidgetRadioButton(int x, int y, int color, ITextComponent text) {
        this(x, y, color, text, null);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawCircle(matrixStack, (float)this.field_230690_l_ + 5.0f, (float)this.field_230691_m_ + 5.0f, 5.0f, this.enabled ? -6250336 : -6710887);
        this.drawCircle(matrixStack, (float)this.field_230690_l_ + 5.0f, (float)this.field_230691_m_ + 5.0f, 4.0f, this.enabled ? -14671840 : -5592406);
        if (this.checked) {
            this.drawCircle(matrixStack, (float)this.field_230690_l_ + 5.0f, (float)this.field_230691_m_ + 5.0f, 1.0f, this.enabled ? -1 : -5592406);
        }
        IReorderingProcessor iReorderingProcessor = this.func_230458_i_().func_241878_f();
        float f = this.field_230690_l_ + 1 + 10;
        float f2 = (float)this.field_230691_m_ + 5.0f;
        this.fontRenderer.getClass();
        this.fontRenderer.func_238422_b_(matrixStack, iReorderingProcessor, f, f2 - 9.0f / 2.0f, this.enabled ? this.color : -7829368);
    }

    private void drawCircle(MatrixStack matrixStack, float x, float y, float radius, int color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        int[] cols = RenderUtils.decomposeColor(color);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((int)770, (int)771);
        wr.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        int i = 0;
        while ((float)i < 12.0f) {
            float sin = MathHelper.func_76126_a((float)((float)i / 12.0f * (float)Math.PI * 2.0f));
            float cos = MathHelper.func_76134_b((float)((float)i / 12.0f * (float)Math.PI * 2.0f));
            wr.func_227888_a_(posMat, x + sin * radius, y + cos * radius, 0.0f).func_225586_a_(cols[1], cols[2], cols[2], cols[0]).func_181675_d();
            ++i;
        }
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public Rectangle2d getBounds() {
        return new Rectangle2d(this.field_230690_l_, this.field_230691_m_, 10 + this.fontRenderer.func_238414_a_((ITextProperties)this.func_230458_i_()), 10);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        if (this.enabled) {
            Validate.notNull(this.otherChoices, (String)"A radio button needs more than one choice! You need to set the GuiRadioButton#otherChoices field!", (Object[])new Object[0]);
            for (WidgetRadioButton radioButton : this.otherChoices) {
                radioButton.checked = false;
            }
            this.checked = true;
            if (this.pressable != null) {
                this.pressable.accept(this);
            }
        }
    }

    public void setTooltip(ITextComponent tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<ITextComponent> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTooltip, boolean shiftPressed) {
        curTooltip.addAll(this.tooltip);
    }
}

