/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WidgetTank
extends Widget
implements ITooltipProvider {
    private final IFluidTank tank;

    public WidgetTank(int x, int y, IFluidTank tank) {
        super(x, y, 16, 64, StringTextComponent.field_240750_d_);
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        this(x, y, (IFluidTank)WidgetTank.makeTank(stack, 160000));
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.tank = WidgetTank.makeTank(stack, stack.getAmount());
    }

    private static FluidTank makeTank(FluidStack stack, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.disableLighting();
        GuiUtils.drawFluid(matrixStack, new Rectangle2d(this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_), this.getFluid(), (IFluidTank)this.getTank());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 300.0);
        for (int i = 3; i < this.field_230689_k_ - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + i), (int)(this.field_230690_l_ + width), (int)(this.field_230691_m_ + i + 1), (int)-13684945);
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<ITextComponent> curTip, boolean shift) {
        Fluid fluid = this.tank.getFluid().getFluid();
        int amt = this.tank.getFluidAmount();
        int capacity = this.tank.getCapacity();
        curTip.add((ITextComponent)new StringTextComponent(amt + "/" + capacity + " mB"));
        if (fluid == Fluids.field_204541_a || amt == 0 || capacity == 0) {
            curTip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.liquid.empty", new Object[0]).func_240699_a_(TextFormatting.GRAY));
        } else {
            curTip.add((ITextComponent)new FluidStack(fluid, amt).getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.GRAY));
            curTip.add((ITextComponent)new StringTextComponent(ModNameCache.getModName(fluid)).func_240701_a_(new TextFormatting[]{TextFormatting.BLUE, TextFormatting.ITALIC}));
        }
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public FluidTank getTank() {
        return (FluidTank)this.tank;
    }
}

