/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public enum ArmorUpgradeClientRegistry {
    INSTANCE;

    private final List<List<IArmorUpgradeClientHandler>> clientUpgradeHandlers = new ArrayList<List<IArmorUpgradeClientHandler>>();
    private final Map<ResourceLocation, IArmorUpgradeClientHandler> id2HandlerMap = new HashMap<ResourceLocation, IArmorUpgradeClientHandler>();
    private final Map<Class<? extends IArmorUpgradeClientHandler>, IArmorUpgradeClientHandler> class2HandlerMap = new HashMap<Class<? extends IArmorUpgradeClientHandler>, IArmorUpgradeClientHandler>();

    public static ArmorUpgradeClientRegistry getInstance() {
        return INSTANCE;
    }

    public void registerHandler(IArmorUpgradeHandler handler, IArmorUpgradeClientHandler clientHandler) {
        this.id2HandlerMap.put(handler.getID(), clientHandler);
        this.class2HandlerMap.put(clientHandler.getClass(), clientHandler);
    }

    public IArmorUpgradeClientHandler getClientHandler(IArmorUpgradeHandler armorUpgradeHandler) {
        return this.id2HandlerMap.get(armorUpgradeHandler.getID());
    }

    public List<IArmorUpgradeClientHandler> getHandlersForSlot(EquipmentSlotType slot) {
        if (this.clientUpgradeHandlers.isEmpty()) {
            this.initHandlerLists();
        }
        return this.clientUpgradeHandlers.get(slot.func_188454_b());
    }

    private void initHandlerLists() {
        if (!this.clientUpgradeHandlers.isEmpty()) {
            throw new IllegalStateException("handler lists already inited!?");
        }
        for (EquipmentSlotType ignored : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            this.clientUpgradeHandlers.add(new ArrayList());
        }
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeHandler handler : ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot)) {
                IArmorUpgradeClientHandler clientHandler = this.getClientHandler(handler);
                Validate.notNull((Object)clientHandler, (String)("Null client-handler for upgrade handler '" + handler.getID() + "'! Did you forget to register it?"), (Object[])new Object[0]);
                this.clientUpgradeHandlers.get(slot.func_188454_b()).add(clientHandler);
            }
        }
        this.refreshConfig();
    }

    public <T extends IArmorUpgradeClientHandler> T byClass(Class<T> clazz) {
        return (T)this.class2HandlerMap.get(clazz);
    }

    public void refreshConfig() {
        if (this.clientUpgradeHandlers.isEmpty()) {
            return;
        }
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            for (IArmorUpgradeClientHandler renderHandler : this.getHandlersForSlot(slot)) {
                renderHandler.initConfig();
            }
        }
    }
}

