/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.entity.RenderSemiblockBase;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderLogisticsFrame
extends RenderSemiblockBase<EntityLogisticsFrame> {
    public static final IRenderFactory<EntityLogisticsFrame> FACTORY = RenderLogisticsFrame::new;
    private static final float FRAME_WIDTH = 0.03125f;

    private RenderLogisticsFrame(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(EntityLogisticsFrame entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float alpha = (float)entity.getAlpha() / 255.0f;
        if (alpha == 0.0f) {
            return;
        }
        float[] cols = RenderUtils.decomposeColorF(entity.getColor());
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        AxisAlignedBB aabb = entity.getBlockBounds().func_72317_d(entity.antiZfight, entity.antiZfight, entity.antiZfight);
        RenderUtils.renderFrame(matrixStackIn, bufferIn, aabb, 0.03125f, cols[1], cols[2], cols[3], alpha, packedLightIn | 0xF00000, false);
        this.drawSideHighlight(entity, aabb, partialTicks, matrixStackIn, bufferIn, cols[1], cols[2], cols[3], alpha);
        matrixStackIn.func_227865_b_();
    }

    private void drawSideHighlight(EntityLogisticsFrame entity, AxisAlignedBB aabb, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float r, float g, float b, float a) {
        double dist = Minecraft.func_71410_x().field_71439_g.func_70068_e((Entity)entity);
        if (dist > 64.0) {
            return;
        }
        double d = 0.05;
        double minX = aabb.field_72340_a + d;
        double minY = aabb.field_72338_b + d;
        double minZ = aabb.field_72339_c + d;
        double maxX = aabb.field_72336_d - d;
        double maxY = aabb.field_72337_e - d;
        double maxZ = aabb.field_72334_f - d;
        RenderUtils.renderWithType(matrixStackIn, bufferIn, ModRenderTypes.getLineLoops(5.0), (posMat, builder) -> {
            switch (entity.getFacing()) {
                case DOWN: {
                    RenderUtils.posF(builder, posMat, minX, aabb.field_72338_b - 0.02, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, aabb.field_72338_b - 0.02, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, aabb.field_72338_b - 0.02, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, aabb.field_72338_b - 0.02, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    break;
                }
                case UP: {
                    RenderUtils.posF(builder, posMat, minX, aabb.field_72337_e + 0.02, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, aabb.field_72337_e + 0.02, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, aabb.field_72337_e + 0.02, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, aabb.field_72337_e + 0.02, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    break;
                }
                case NORTH: {
                    RenderUtils.posF(builder, posMat, maxX, minY, aabb.field_72339_c - 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, minY, aabb.field_72339_c - 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, maxY, aabb.field_72339_c - 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, maxY, aabb.field_72339_c - 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    break;
                }
                case SOUTH: {
                    RenderUtils.posF(builder, posMat, maxX, maxY, aabb.field_72334_f + 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, maxY, aabb.field_72334_f + 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, minX, minY, aabb.field_72334_f + 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, maxX, minY, aabb.field_72334_f + 0.02).func_227885_a_(r, g, b, a).func_181675_d();
                    break;
                }
                case WEST: {
                    RenderUtils.posF(builder, posMat, aabb.field_72340_a - 0.02, minY, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72340_a - 0.02, minY, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72340_a - 0.02, maxY, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72340_a - 0.02, maxY, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    break;
                }
                case EAST: {
                    RenderUtils.posF(builder, posMat, aabb.field_72336_d + 0.02, maxY, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72336_d + 0.02, maxY, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72336_d + 0.02, minY, maxZ).func_227885_a_(r, g, b, a).func_181675_d();
                    RenderUtils.posF(builder, posMat, aabb.field_72336_d + 0.02, minY, minZ).func_227885_a_(r, g, b, a).func_181675_d();
                }
            }
        });
    }

    public ResourceLocation getEntityTexture(EntityLogisticsFrame entityLogisticsFrame) {
        return null;
    }
}

