/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import me.desht.pneumaticcraft.common.entity.projectile.EntityTumblingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderTumblingBlock
extends EntityRenderer<EntityTumblingBlock> {
    public static final IRenderFactory<EntityTumblingBlock> FACTORY = RenderTumblingBlock::new;
    private static final Vector3f ROT_VEC = new Vector3f(1.0f, 0.0f, 1.0f);

    private RenderTumblingBlock(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EntityTumblingBlock entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        World world;
        ItemStack stack = entity.getStack();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) {
            return;
        }
        Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
        BlockState state = block.func_176223_P();
        if (state.func_185901_i() == BlockRenderType.MODEL && state != (world = entity.func_130014_f_()).func_180495_p(entity.func_233580_cy_()) && state.func_185901_i() != BlockRenderType.INVISIBLE) {
            matrixStackIn.func_227860_a_();
            if (entity.tumbleVec != null) {
                matrixStackIn.func_227861_a_(0.0, 0.5, 0.0);
                float angle = ((float)entity.field_70173_aa + partialTicks) * 18.0f;
                matrixStackIn.func_227863_a_(entity.tumbleVec.func_229187_a_(angle));
                matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            }
            BlockPos blockpos = new BlockPos(entity.func_226277_ct_(), entity.func_174813_aQ().field_72337_e, entity.func_226281_cx_());
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)type);
                blockrendererdispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, blockrendererdispatcher.func_184389_a(state), state, blockpos, matrixStackIn, bufferIn.getBuffer(type), false, new Random(), state.func_209533_a(entity.getOrigin()), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            }
            ForgeHooksClient.setRenderLayer(null);
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(EntityTumblingBlock entity) {
        return null;
    }
}

