/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;

public class RenderNavigator {
    private final BlockPos targetPos;
    private Path path;
    private boolean increaseAlpha;
    private float alphaValue = 0.2f;

    public RenderNavigator(World world, BlockPos targetPos) {
        this.targetPos = targetPos;
        this.updatePath();
    }

    public void updatePath() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        MobEntity e = PneumaticCraftUtils.createDummyEntity((PlayerEntity)player);
        e.func_230245_c_(player.func_233570_aj_());
        this.path = e.func_70661_as().func_179680_a(this.targetPos, 1);
        if (!this.tracedToDestination()) {
            this.path = CoordTrackClientHandler.getDronePath((PlayerEntity)player, this.targetPos);
        }
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, boolean wirePath, boolean xRayEnabled, float partialTicks) {
        if (this.path == null) {
            return;
        }
        boolean hasDestinationPath = this.tracedToDestination();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.01, 0.0);
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        if (wirePath) {
            IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getNavPath(xRayEnabled, false));
            for (int i = 1; i < this.path.func_75874_d(); ++i) {
                float red = 1.0f;
                if (this.path.func_75874_d() - i < 200) {
                    red = (float)(this.path.func_75874_d() - i) * 0.005f;
                }
                PathPoint lastPoint = this.path.func_75877_a(i - 1);
                PathPoint pathPoint = this.path.func_75877_a(i);
                builder.func_227888_a_(posMat, (float)lastPoint.field_75839_a + 0.5f, (float)lastPoint.field_75837_b, (float)lastPoint.field_75838_c + 0.5f).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
                builder.func_227888_a_(posMat, (float)(lastPoint.field_75839_a + pathPoint.field_75839_a) / 2.0f + 0.5f, (float)Math.max(lastPoint.field_75837_b, pathPoint.field_75837_b), (float)(lastPoint.field_75838_c + pathPoint.field_75838_c) / 2.0f + 0.5f).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
                builder.func_227888_a_(posMat, (float)pathPoint.field_75839_a + 0.5f, (float)pathPoint.field_75837_b, (float)pathPoint.field_75838_c + 0.5f).func_227885_a_(red, 1.0f - red, 0.0f, 0.5f).func_181675_d();
            }
        } else {
            IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.getNavPath(xRayEnabled, true));
            if (hasDestinationPath) {
                if (this.alphaValue > 0.2f) {
                    this.alphaValue -= 0.005f;
                }
            } else if (this.increaseAlpha) {
                this.alphaValue += 0.005f;
                if (this.alphaValue > 0.3f) {
                    this.increaseAlpha = false;
                }
            } else {
                this.alphaValue -= 0.005f;
                if (this.alphaValue < 0.2f) {
                    this.increaseAlpha = true;
                }
            }
            for (int i = 0; i < this.path.func_75874_d(); ++i) {
                float red = 1.0f;
                if (this.path.func_75874_d() - i < 200) {
                    red = (float)(this.path.func_75874_d() - i) * 0.005f;
                }
                PathPoint pathPoint = this.path.func_75877_a(i);
                builder.func_227888_a_(posMat, (float)pathPoint.field_75839_a, (float)pathPoint.field_75837_b, (float)pathPoint.field_75838_c).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_227888_a_(posMat, (float)pathPoint.field_75839_a, (float)pathPoint.field_75837_b, (float)(pathPoint.field_75838_c + 1)).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_227888_a_(posMat, (float)(pathPoint.field_75839_a + 1), (float)pathPoint.field_75837_b, (float)(pathPoint.field_75838_c + 1)).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
                builder.func_227888_a_(posMat, (float)(pathPoint.field_75839_a + 1), (float)pathPoint.field_75837_b, (float)pathPoint.field_75838_c).func_227885_a_(red, 1.0f - red, 0.0f, this.alphaValue).func_181675_d();
            }
        }
        matrixStack.func_227865_b_();
    }

    public boolean tracedToDestination() {
        if (this.path == null) {
            return false;
        }
        PathPoint finalPoint = this.path.func_75870_c();
        return finalPoint != null && this.targetPos.equals((Object)new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c));
    }
}

