/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class RenderTargetCircle {
    private static final float[] DRONE = new float[]{1.0f, 1.0f, 0.0f};
    private static final float[] HANGING = new float[]{0.0f, 1.0f, 1.0f};
    private static final float[] HOSTILE = new float[]{1.0f, 0.0f, 0.0f};
    private static final float[] DEFAULT = new float[]{0.0f, 1.0f, 0.0f};
    private double oldRotationAngle;
    private double rotationAngle = 0.0;
    private double rotationSpeed = 0.0;
    private double rotationAcceleration = 0.0;
    private final Random rand;
    private boolean renderAsTagged;
    private final float[] cols = new float[4];

    RenderTargetCircle(Entity entity) {
        this.rand = new Random();
        System.arraycopy(this.getCircleColour(entity), 0, this.cols, 0, 3);
        this.cols[3] = 0.5f;
    }

    void setRenderingAsTagged(boolean tagged) {
        this.renderAsTagged = tagged;
    }

    public void update() {
        this.oldRotationAngle = this.rotationAngle;
        if (this.rand.nextInt(15) == 0) {
            this.rotationAcceleration = (this.rand.nextDouble() - 0.5) / 2.5;
        }
        this.rotationSpeed += this.rotationAcceleration;
        double maxSpeed = 8.0;
        if (this.rotationSpeed >= maxSpeed) {
            this.rotationSpeed = maxSpeed;
        }
        if (this.rotationSpeed <= -maxSpeed) {
            this.rotationSpeed = -maxSpeed;
        }
        this.rotationAngle += this.rotationSpeed;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, float size, float partialTicks, float alpha) {
        double renderRotationAngle = MathHelper.func_219803_d((double)partialTicks, (double)this.oldRotationAngle, (double)this.rotationAngle);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)renderRotationAngle));
        for (int pass = 0; pass < 2; ++pass) {
            RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.TARGET_CIRCLE, (posMat, builder) -> {
                for (int i = 0; i < 125; ++i) {
                    RenderUtils.posF(builder, posMat, PneumaticCraftUtils.cos[i] * (double)size, PneumaticCraftUtils.sin[i] * (double)size, 0.0).func_227885_a_(this.cols[0], this.cols[1], this.cols[2], alpha).func_181675_d();
                    RenderUtils.posF(builder, posMat, PneumaticCraftUtils.cos[i] * (double)(size + 0.1f), PneumaticCraftUtils.sin[i] * (double)(size + 0.1f), 0.0).func_227885_a_(this.cols[0], this.cols[1], this.cols[2], alpha).func_181675_d();
                }
            });
            if (this.renderAsTagged) {
                RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getLineLoopsTransparent(3.0), (posMat, builder) -> {
                    int i;
                    for (i = 0; i < 125; ++i) {
                        RenderUtils.posF(builder, posMat, PneumaticCraftUtils.cos[i] * (double)size, PneumaticCraftUtils.sin[i] * (double)size, 0.0).func_225586_a_(255, 0, 0, 255).func_181675_d();
                    }
                    for (i = 124; i >= 0; --i) {
                        RenderUtils.posF(builder, posMat, PneumaticCraftUtils.cos[i] * (double)(size + 0.1f), PneumaticCraftUtils.sin[i] * (double)(size + 0.1f), 0.0).func_225586_a_(255, 0, 0, 255).func_181675_d();
                    }
                });
            }
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
        matrixStack.func_227865_b_();
    }

    private float[] getCircleColour(Entity entity) {
        if (entity instanceof EntityDrone) {
            return DRONE;
        }
        if (entity instanceof IMob) {
            return HOSTILE;
        }
        if (entity instanceof HangingEntity) {
            return HANGING;
        }
        return DEFAULT;
    }
}

