/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.CoordinateTrackerOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderCoordWireframe;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderNavigator;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CoordTrackClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler {
    private RenderCoordWireframe coordTracker;
    private RenderNavigator navigator;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    public ClientConfig.PathUpdateSetting pathUpdateSetting = ClientConfig.PathUpdateSetting.NORMAL;
    private int pathCalculateCooldown;
    private int noPathCooldown;

    public CoordTrackClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().coordTrackerHandler);
    }

    @Override
    public void initConfig() {
        this.pathEnabled = PNCConfig.Client.Armor.pathEnabled;
        this.wirePath = PNCConfig.Client.Armor.wirePath;
        this.xRayEnabled = PNCConfig.Client.Armor.xRayEnabled;
        this.pathUpdateSetting = PNCConfig.Client.Armor.pathUpdateSetting;
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.updateCoordTracker(this.pathEnabled, this.wirePath, this.xRayEnabled, this.pathUpdateSetting);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        if (this.coordTracker != null) {
            ++this.coordTracker.ticksExisted;
        } else {
            BlockPos pos = ItemPneumaticArmor.getCoordTrackerPos(ClientUtils.getWornArmor(EquipmentSlotType.HEAD), armorHandler.getPlayer().field_70170_p);
            if (pos != null) {
                this.coordTracker = new RenderCoordWireframe(armorHandler.getPlayer().field_70170_p, pos);
                this.navigator = new RenderNavigator(this.coordTracker.world, this.coordTracker.pos);
            }
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && PNCConfig.Client.Armor.pathEnabled && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = PNCConfig.Client.Armor.pathUpdateSetting.getTicks();
        }
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        if (this.coordTracker != null) {
            if (!Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.coordTracker.world.func_234923_W_().func_240901_a_())) {
                return;
            }
            this.coordTracker.render(matrixStack, buffer, partialTicks);
            if (PNCConfig.Client.Armor.pathEnabled && this.navigator != null) {
                this.navigator.render(matrixStack, buffer, PNCConfig.Client.Armor.wirePath, PNCConfig.Client.Armor.xRayEnabled, partialTicks);
            }
        }
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean upgradeEnabled) {
    }

    @Override
    public void reset() {
        this.coordTracker = null;
        this.navigator = null;
    }

    public EnumNavigationResult navigateToSurface(PlayerEntity player) {
        BlockPos pathPos;
        PathPoint pathPoint;
        int i;
        World world = player.field_70170_p;
        BlockPos navigatingPos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, player.func_233580_cy_());
        MobEntity e = PneumaticCraftUtils.createDummyEntity(player);
        Path path = e.func_70661_as().func_179680_a(navigatingPos, 0);
        if (path != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175710_j(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackClientHandler.getDronePath(player, navigatingPos)) != null) {
            for (i = 0; i < path.func_75874_d(); ++i) {
                pathPoint = path.func_75877_a(i);
                pathPos = new BlockPos(pathPoint.field_75839_a, pathPoint.field_75837_b, pathPoint.field_75838_c);
                if (!world.func_175710_j(pathPos)) continue;
                this.coordTracker = new RenderCoordWireframe(world, pathPos);
                this.navigator = new RenderNavigator(world, pathPos);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static Path getDronePath(PlayerEntity player, BlockPos pos) {
        World world = player.field_70170_p;
        EntityDrone drone = new EntityDrone((EntityType<? extends EntityDrone>)((EntityType)ModEntities.DRONE.get()), world);
        drone.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        return new EntityPathNavigateDrone(drone, world).func_179680_a(pos, 0);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new CoordinateTrackerOptions(screen, this);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
            ItemStack helmetStack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
            if (!event.getWorld().field_72995_K || event.getPlayer().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != ModItems.PNEUMATIC_HELMET.get()) {
                return;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            if (commonArmorHandler.getUpgradeCount(EquipmentSlotType.HEAD, EnumUpgrade.COORDINATE_TRACKER) == 0) {
                return;
            }
            CoordTrackClientHandler handler = (CoordTrackClientHandler)ArmorUpgradeClientRegistry.getInstance().getClientHandler(ArmorUpgradeRegistry.getInstance().coordTrackerHandler);
            if (handler.isListeningToCoordTrackerSetting) {
                handler.isListeningToCoordTrackerSetting = false;
                if (event.getFace() != null) {
                    handler.reset();
                    GlobalPos gPos = GlobalPosHelper.makeGlobalPos(event.getWorld(), event.getPos().func_177972_a(event.getFace()));
                    ItemPneumaticArmor.setCoordTrackerPos(helmetStack, gPos);
                    CompoundNBT tag = new CompoundNBT();
                    tag.func_218657_a("CoordTracker", (INBT)GlobalPosHelper.toNBT(gPos));
                    NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlotType.HEAD, tag));
                    HUDHandler.getInstance().addMessage((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.selectedTarget", PneumaticCraftUtils.posToString(gPos.func_218180_b())), Collections.emptyList(), 60, -2147440128);
                }
            }
        }
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }
}

