/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.CoreComponentsOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class CoreComponentsClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler {
    private static final int MAX_BARS = 40;
    private static final String[] BAR_STR_CACHE = new String[41];
    private WidgetAnimatedStat powerStat;
    public WidgetAnimatedStat testMessageStat;
    public boolean showPressureNumerically;

    public CoreComponentsClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().coreComponentsHandler);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        List<String> l = Arrays.stream(ArmorUpgradeRegistry.ARMOR_SLOTS).map(slot -> this.getPressureStr(armorHandler, (EquipmentSlotType)slot)).collect(Collectors.toList());
        this.powerStat.setTextWithoutCuttingString(l);
    }

    @Override
    public void initConfig() {
        this.showPressureNumerically = PNCConfig.Client.Armor.showPressureNumerically;
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.setShowPressureNumerically(this.showPressureNumerically);
    }

    private String getPressureStr(ICommonArmorHandler handler, EquipmentSlotType slot) {
        if (!ItemPneumaticArmor.isPneumaticArmorPiece(handler.getPlayer(), slot)) {
            return TextFormatting.DARK_GRAY + "-";
        }
        float pressure = handler.getArmorPressure(slot);
        if (this.showPressureNumerically) {
            return this.getColourForPressure(pressure) + String.format("%4.1f", Float.valueOf(pressure));
        }
        return this.getBarStr(pressure);
    }

    private TextFormatting getColourForPressure(float pressure) {
        if (pressure < 0.5f) {
            return TextFormatting.RED;
        }
        if (pressure < 2.0f) {
            return TextFormatting.GOLD;
        }
        if (pressure < 4.0f) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    private String getBarStr(float pressure) {
        int scaled = (int)(40.0f * pressure / 10.0f);
        int idx = MathHelper.func_76125_a((int)scaled, (int)0, (int)40);
        if (BAR_STR_CACHE[idx] == null) {
            int n2 = 40 - scaled;
            CoreComponentsClientHandler.BAR_STR_CACHE[idx] = this.getColourForPressure(pressure) + Strings.repeat((String)"|", (int)scaled) + TextFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)n2);
        }
        return BAR_STR_CACHE[idx];
    }

    @Override
    public void render3D(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean helmetEnabled) {
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.powerStat == null) {
            this.powerStat = new WidgetAnimatedStat(null, StringTextComponent.field_240750_d_, WidgetAnimatedStat.StatIcon.NONE, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.powerStat);
            this.powerStat.setLineSpacing(15);
            this.powerStat.setWidgetOffsets(-18, 0);
            for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                WidgetButtonExtended pressureButton = new WidgetButtonExtended(0, 5 + (3 - slot.func_188454_b()) * 15, 18, 18, "");
                ItemStack stack = GuiArmorMainScreen.ARMOR_STACKS[slot.func_188454_b()];
                pressureButton.setVisible(false);
                pressureButton.setRenderStacks(stack);
                this.powerStat.addSubWidget((Widget)pressureButton);
            }
            this.powerStat.setMinDimensionsAndReset(0, 0);
            this.powerStat.openStat();
        }
        return this.powerStat;
    }

    @Override
    public void reset() {
        this.powerStat = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new CoreComponentsOptions(screen, this);
    }

    @Override
    public void onResolutionChanged() {
        this.powerStat = null;
    }
}

