/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.option_screens.JetBootsOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.Heightmap;

public class JetBootsClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler {
    public static final int BUILDER_MODE_LEVEL = 3;
    private static final String[] HEADINGS = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    private String l1;
    private String l2;
    private String l3;
    private String r1;
    private String r2;
    private String r3;
    private int widestR;
    private boolean drawShovel;
    private IGuiAnimatedStat jbStat;

    public JetBootsClientHandler() {
        super(ArmorUpgradeRegistry.getInstance().jetBootsHandler);
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new JetBootsOptions(screen, this);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        super.tickClient(armorHandler);
        String g1 = TextFormatting.WHITE.toString();
        String g2 = TextFormatting.GREEN.toString();
        PlayerEntity player = armorHandler.getPlayer();
        if (this.jbStat.isStatOpen()) {
            double mx = player.func_226277_ct_() - player.field_70169_q;
            double my = player.func_226278_cu_() - player.field_70167_r;
            double mz = player.func_226281_cx_() - player.field_70166_s;
            double v = Math.sqrt(mx * mx + my * my + mz * mz);
            double vg = Math.sqrt(mx * mx + mz * mz);
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            int yaw = ((int)player.field_70177_z + 180) % 360;
            if (yaw < 0) {
                yaw += 360;
            }
            BlockPos pos = player.func_233580_cy_();
            this.l1 = String.format(" %sSpd: %s%05.2fm/s", g1, g2, v * 20.0);
            this.l2 = String.format("  %sAlt: %s%03dm", g1, g2, pos.func_177956_o());
            this.l3 = String.format("%sHead: %s%d\u00b0 (%s)", g1, g2, yaw, HEADINGS[heading]);
            this.r1 = String.format("%sGnd: %s%05.2f", g1, g2, vg * 20.0);
            this.r2 = String.format("%sGnd: %s%dm", g1, g2, pos.func_177956_o() - player.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p()));
            this.r3 = String.format("%sPch: %s%d\u00b0", g1, g2, (int)(-player.field_70125_A));
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            this.widestR = Math.max(fr.func_78256_a(this.r1), Math.max(fr.func_78256_a(this.r2), fr.func_78256_a(this.r3)));
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            this.drawShovel = handler.isJetBootsBuilderMode();
        }
    }

    @Override
    public void render2D(MatrixStack matrixStack, float partialTicks, boolean helmetEnabled) {
        super.render2D(matrixStack, partialTicks, helmetEnabled);
        if (helmetEnabled && this.jbStat.isStatOpen()) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int xl = this.jbStat.getBaseX() + 5;
            int n = this.jbStat.getBaseY();
            fr.getClass();
            int y = n + 9 + 8;
            int xr = this.jbStat.getBaseX() + this.jbStat.getStatWidth() - 5;
            if (this.jbStat.isLeftSided()) {
                xl -= this.jbStat.getStatWidth();
                xr -= this.jbStat.getStatWidth();
            }
            fr.func_238405_a_(matrixStack, this.l1, (float)xl, (float)y, 0x404040);
            float f = xl;
            fr.getClass();
            fr.func_238405_a_(matrixStack, this.l2, f, (float)(y + 9), 0x404040);
            float f2 = xl;
            fr.getClass();
            fr.func_238405_a_(matrixStack, this.l3, f2, (float)(y + 9 * 2), 0x404040);
            fr.func_238405_a_(matrixStack, this.r1, (float)(xr - this.widestR), (float)y, 0x404040);
            float f3 = xr - this.widestR;
            fr.getClass();
            fr.func_238405_a_(matrixStack, this.r2, f3, (float)(y + 9), 0x404040);
            float f4 = xr - this.widestR;
            fr.getClass();
            fr.func_238405_a_(matrixStack, this.r3, f4, (float)(y + 9 * 2), 0x404040);
            if (this.drawShovel) {
                GuiUtils.renderItemStack(matrixStack, new ItemStack((IItemProvider)Items.field_151046_w), xr - 30, this.jbStat.getBaseY());
            }
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.jbStat == null) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            int n = Math.max(1, handler.getUpgradeCount(EquipmentSlotType.FEET, EnumUpgrade.JET_BOOTS));
            ItemStack stack = new ItemStack((IItemProvider)EnumUpgrade.JET_BOOTS.getItem(n));
            this.jbStat = new WidgetAnimatedStat(null, (ITextComponent)PneumaticCraftUtils.xlate(ArmorUpgradeRegistry.getStringKey(this.getCommonHandler().getID()), new Object[0]), WidgetAnimatedStat.StatIcon.of(stack), 0x3000AA00, null, ArmorHUDLayout.INSTANCE.jetBootsStat);
            this.jbStat.setMinDimensionsAndReset(0, 0);
            this.jbStat.addPadding(3, 32);
        }
        return this.jbStat;
    }

    @Override
    public void onResolutionChanged() {
        this.jbStat = null;
    }
}

