/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.apache.commons.lang3.tuple.Pair;

public class ProgWidgetRenderer {
    private static final Map<ResourceLocation, BiConsumer<MatrixStack, IProgWidget>> extraRenderers = new HashMap<ResourceLocation, BiConsumer<MatrixStack, IProgWidget>>();

    public static void renderProgWidget2d(MatrixStack matrixStack, IProgWidget progWidget, int alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(progWidget.getTexture());
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        wr.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        wr.func_227888_a_(posMat, 0.0f, (float)height, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, v).func_181675_d();
        wr.func_227888_a_(posMat, (float)width, (float)height, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(u, v).func_181675_d();
        wr.func_227888_a_(posMat, (float)width, 0.0f, 0.0f).func_225586_a_(255, 255, 255, alpha).func_225583_a_(u, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderProgWidget2d(MatrixStack matrixStack, IProgWidget progWidget) {
        ProgWidgetRenderer.renderProgWidget2d(matrixStack, progWidget, 255);
    }

    public static void renderProgWidget3d(MatrixStack matrixStack, IRenderTypeBuffer buffer, IProgWidget progWidget) {
        int width = progWidget.getWidth() + (progWidget.getParameters().isEmpty() ? 0 : 10);
        int height = progWidget.getHeight() + (progWidget.hasStepOutput() ? 10 : 0);
        Pair<Float, Float> maxUV = progWidget.getMaxUV();
        float u = ((Float)maxUV.getLeft()).floatValue();
        float v = ((Float)maxUV.getRight()).floatValue();
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(progWidget.getTexture()), (posMat, builder) -> {
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)width, 0.0f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, (float)width, (float)height, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(posMat, 0.0f, (float)height, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, v).func_227886_a_(0xF000F0).func_181675_d();
        });
    }

    public static void doExtraRendering2d(MatrixStack matrixStack, IProgWidget widget) {
        extraRenderers.getOrDefault(widget.getTypeID(), ProgWidgetRenderer::renderGenericExtras).accept(matrixStack, widget);
    }

    public static <P extends IProgWidget> void registerExtraRenderer(ProgWidgetType<P> type, BiConsumer<MatrixStack, P> consumer) {
        extraRenderers.put(type.getRegistryName(), consumer);
    }

    public static void renderGenericExtras(MatrixStack matrixStack, IProgWidget progWidget) {
        String info = progWidget.getExtraStringInfo();
        if (info != null && !info.isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            List<String> splittedInfo = PneumaticCraftUtils.splitString(info, 20);
            for (int i = 0; i < splittedInfo.size(); ++i) {
                int stringLength = fr.func_78256_a(splittedInfo.get(i));
                int startX = progWidget.getWidth() / 2 - stringLength / 4;
                int n = progWidget.getHeight() / 2;
                fr.getClass();
                int n2 = n - (9 + 1) * (splittedInfo.size() - 1) / 4;
                fr.getClass();
                int n3 = n2 + (9 + 1) * i / 2;
                fr.getClass();
                int startY = n3 - 9 / 4;
                fr.getClass();
                AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(startX * 2 - 1), (int)(startY * 2 - 1), (int)(startX * 2 + stringLength + 1), (int)(startY * 2 + 9 + 1), (int)-1);
                fr.func_238421_b_(matrixStack, splittedInfo.get(i), (float)(startX * 2), (float)(startY * 2), -16777216);
            }
            matrixStack.func_227865_b_();
        }
    }

    public static void renderCraftingExtras(MatrixStack matrixStack, ProgWidgetCrafting progWidget) {
        ItemStack recipe = progWidget.getRecipeResult(ClientUtils.getClientWorld());
        if (recipe != null) {
            GuiUtils.renderItemStack(matrixStack, recipe, 8, progWidget.getHeight() / 2 - 8);
            GuiUtils.renderItemStackOverlay(matrixStack, Minecraft.func_71410_x().field_71466_p, recipe, 8, progWidget.getHeight() / 2 - 8, Integer.toString(recipe.func_190916_E()));
        }
    }

    public static void renderItemFilterExtras(MatrixStack matrixStack, ProgWidgetItemFilter progWidget) {
        if (progWidget.getVariable().isEmpty()) {
            if (!progWidget.getFilter().func_190926_b()) {
                GuiUtils.renderItemStack(matrixStack, progWidget.getFilter(), 10, 2);
                GuiUtils.renderItemStackOverlay(matrixStack, Minecraft.func_71410_x().field_71466_p, progWidget.getFilter(), 10, 2, "");
            }
        } else {
            ProgWidgetRenderer.renderGenericExtras(matrixStack, progWidget);
        }
    }
}

