/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import me.desht.pneumaticcraft.client.gui.GuiSecurityStationBase;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class ProgressingLine {
    public float startX;
    public float startY;
    public float startZ;
    public float endX;
    public float endY;
    public float endZ;
    protected float progress = 0.0f;

    public ProgressingLine() {
    }

    public ProgressingLine(Vector3f start, Vector3f end) {
        this.startX = start.func_195899_a();
        this.startX = start.func_195900_b();
        this.startX = start.func_195902_c();
        this.endX = end.func_195899_a();
        this.endY = end.func_195900_b();
        this.endZ = end.func_195902_c();
    }

    public ProgressingLine(Vector3d start, Vector3d end) {
        this(new Vector3f(start), new Vector3f(end));
    }

    public ProgressingLine(float startX, float startY, float startZ, float endX, float endY, float endZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
    }

    public ProgressingLine(float startX, float startY, float endX, float endY) {
        this(new Vector3f(startX, startY, 0.0f), new Vector3f(endX, endY, 0.0f));
    }

    public ProgressingLine(ProgressingLine copy) {
        this(copy.startX, copy.startY, copy.startZ, copy.endX, copy.endY, copy.endZ);
        this.progress = copy.progress;
    }

    public boolean hasLineSameProperties(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return Math.abs(startX - (double)this.startX) < 0.01 && Math.abs(startY - (double)this.startY) < 0.01 && Math.abs(startZ - (double)this.startZ) < 0.01 && Math.abs(endX - (double)this.endX) < 0.01 && Math.abs(endY - (double)this.endY) < 0.01 && Math.abs(endZ - (double)this.endZ) < 0.01;
    }

    public float getProgress() {
        return this.progress;
    }

    public ProgressingLine setProgress(float progress) {
        this.progress = progress;
        return this;
    }

    public boolean incProgress(float increment) {
        this.progress += increment;
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public boolean incProgressByDistance(double distance) {
        double totalDistance = Math.sqrt(Math.pow(this.endX - this.startX, 2.0) + Math.pow(this.endY - this.startY, 2.0) + Math.pow(this.endZ - this.startZ, 2.0));
        this.progress = (float)((double)this.progress + distance / totalDistance);
        if (this.progress > 1.0f) {
            this.progress = 1.0f;
            return true;
        }
        if (this.progress < 0.0f) {
            this.progress = 0.0f;
            return true;
        }
        return false;
    }

    public int getPointedSlotNumber(GuiSecurityStationBase gui) {
        Slot slot = gui.getSlotAtPosition((int)this.endX, (int)this.endY);
        return slot != null ? slot.field_75222_d : 0;
    }
}

