/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import net.minecraft.util.math.BlockPos;

public class RangeLines {
    private final List<ProgressingLine> rangeLines = new ArrayList<ProgressingLine>();
    private int rangeLinesTimer = 0;
    private final int color;
    private final BlockPos pos;

    public RangeLines(int color) {
        this(color, null);
    }

    public RangeLines(int color, BlockPos pos) {
        this.color = color;
        this.pos = pos;
    }

    public int getColor() {
        return this.color;
    }

    public Collection<ProgressingLine> getLines() {
        return this.rangeLines;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void startRendering(float range) {
        this.rangeLinesTimer = 120;
        this.rangeLines.clear();
        float r = range + 0.5f;
        int i = 0;
        while ((float)i < range * 16.0f + 8.0f) {
            this.rangeLines.add(new ProgressingLine(-r + (float)i / 8.0f, -r + 1.0f, -r, -r + (float)i / 8.0f, r + 1.0f, -r));
            this.rangeLines.add(new ProgressingLine(r - (float)i / 8.0f, -r + 1.0f, r, r - (float)i / 8.0f, r + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(-r, -r + 1.0f, r - (float)i / 8.0f, -r, r + 1.0f, r - (float)i / 8.0f));
            this.rangeLines.add(new ProgressingLine(r, -r + 1.0f, -r + (float)i / 8.0f, r, r + 1.0f, -r + (float)i / 8.0f));
            this.rangeLines.add(new ProgressingLine(-r, -r + (float)i / 8.0f + 1.0f, -r, -r, -r + (float)i / 8.0f + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(r, -r + (float)i / 8.0f + 1.0f, -r, r, -r + (float)i / 8.0f + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(-r, r - (float)i / 8.0f + 1.0f, -r, r, r - (float)i / 8.0f + 1.0f, -r));
            this.rangeLines.add(new ProgressingLine(-r, -r + (float)i / 8.0f + 1.0f, r, r, -r + (float)i / 8.0f + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(r - (float)i / 8.0f, -r + 1.0f, -r, r - (float)i / 8.0f, -r + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(r - (float)i / 8.0f, r + 1.0f, -r, r - (float)i / 8.0f, r + 1.0f, r));
            this.rangeLines.add(new ProgressingLine(-r, -r + 1.0f, -r + (float)i / 8.0f, r, -r + 1.0f, -r + (float)i / 8.0f));
            this.rangeLines.add(new ProgressingLine(-r, r + 1.0f, -r + (float)i / 8.0f, r, r + 1.0f, -r + (float)i / 8.0f));
            ++i;
        }
    }

    public boolean shouldRender() {
        return this.rangeLines.size() > 0;
    }

    public void tick(Random rand) {
        if (this.rangeLinesTimer > 0) {
            --this.rangeLinesTimer;
            for (ProgressingLine line : this.rangeLines) {
                if (!(line.getProgress() > 0.005f) && rand.nextInt(15) != 0) continue;
                line.incProgress(0.025f);
            }
        } else {
            Iterator<ProgressingLine> iterator = this.rangeLines.iterator();
            while (iterator.hasNext()) {
                ProgressingLine line = iterator.next();
                if (line.getProgress() > 0.005f) {
                    line.incProgress(0.025f);
                }
                if (rand.nextInt(8) != 0) continue;
                iterator.remove();
            }
        }
    }
}

