/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class DroneAIAttackEntity
extends MeleeAttackGoal {
    private final EntityDrone attacker;
    private final boolean isRanged;
    private final double rangedAttackRange;

    public DroneAIAttackEntity(EntityDrone attacker, double speed, boolean useLongMemory) {
        super((CreatureEntity)attacker, speed, useLongMemory);
        ItemStack stack;
        this.attacker = attacker;
        this.isRanged = attacker.hasMinigun();
        float rangeMult = 1.0f;
        if (this.isRanged && (stack = attacker.getMinigun().getAmmoStack()).func_77973_b() instanceof ItemGunAmmo) {
            rangeMult = ((ItemGunAmmo)stack.func_77973_b()).getRangeMultiplier(stack);
        }
        this.rangedAttackRange = (float)(16 + Math.min(16, attacker.getUpgrades(EnumUpgrade.RANGE))) * rangeMult;
    }

    public boolean func_75250_a() {
        if (this.isRanged && this.attacker.getSlotForAmmo() < 0) {
            this.attacker.addDebugEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noAmmo");
            return false;
        }
        LivingEntity entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            this.attacker.addDebugEntry("pneumaticcraft.gui.progWidget.entityAttack.debug.noEntityToAttack");
        }
        return super.func_75250_a();
    }

    public void func_75249_e() {
        super.func_75249_e();
        if (this.attacker.func_70638_az() != null && this.attacker.getInv().getSlots() > 1) {
            int bestSlot = 0;
            double bestDmg = 0.0;
            for (int i = 0; i < this.attacker.getInv().getSlots(); ++i) {
                ItemStack stack = this.attacker.getInv().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ModifiableAttributeInstance damage = new ModifiableAttributeInstance(Attributes.field_233823_f_, c -> {});
                for (AttributeModifier modifier : stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_)) {
                    damage.func_233767_b_(modifier);
                }
                float f1 = EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)this.attacker.func_70638_az().func_70668_bt());
                if (!(damage.func_111126_e() + (double)f1 > bestDmg)) continue;
                bestDmg = damage.func_111126_e() + (double)f1;
                bestSlot = i;
            }
            if (bestSlot != 0) {
                ItemStack copy = this.attacker.getInv().getStackInSlot(0).func_77946_l();
                this.attacker.getInv().setStackInSlot(0, this.attacker.getInv().getStackInSlot(bestSlot));
                this.attacker.getInv().setStackInSlot(bestSlot, copy);
            }
        }
    }

    public boolean func_75253_b() {
        if (this.isRanged) {
            LivingEntity entitylivingbase = this.attacker.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            double dist = this.attacker.func_70092_e(entitylivingbase.func_226277_ct_(), entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.func_226281_cx_());
            if (this.attacker.getSlotForAmmo() < 0) {
                return false;
            }
            if (dist < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                return true;
            }
        }
        return super.func_75253_b();
    }

    public void func_75251_c() {
    }

    public void func_75246_d() {
        LivingEntity entitylivingbase;
        double dist;
        boolean needingSuper = true;
        if (this.isRanged && (dist = this.attacker.func_70092_e((entitylivingbase = this.attacker.func_70638_az()).func_226277_ct_(), entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.func_226281_cx_())) < Math.pow(this.rangedAttackRange, 2.0) && this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
            this.attacker.getFakePlayer().func_70107_b(this.attacker.func_226277_ct_(), this.attacker.func_226278_cu_(), this.attacker.func_226281_cx_());
            this.attacker.tryFireMinigun(entitylivingbase);
            needingSuper = false;
            if (dist < Math.pow(this.rangedAttackRange * 0.75, 2.0)) {
                this.attacker.func_70661_as().func_75499_g();
            }
        }
        if (needingSuper) {
            super.func_75246_d();
        }
    }
}

