/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.api.harvesting.HoeHandler;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModRegistries;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class DroneAIHarvest<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIHarvest(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    public boolean func_75250_a() {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return this.getApplicableHandler(pos) != null;
    }

    private boolean abortIfRequiredHoeIsMissing() {
        if (((IToolUser)((Object)this.progWidget)).requiresTool() && this.getDamageableHoe() == null) {
            this.abort();
            this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.harvest.debug.missingHoe");
            return true;
        }
        return false;
    }

    private HarvestHandler getApplicableHandler(BlockPos pos) {
        BlockState state = this.worldCache.func_180495_p(pos);
        return ModRegistries.HARVEST_HANDLERS.getValues().stream().filter(handler -> handler.canHarvest(this.drone.world(), (IBlockReader)this.worldCache, pos, state, this.drone) && this.hasApplicableItemFilters((HarvestHandler)((Object)handler), pos, state)).findFirst().orElse(null);
    }

    private boolean hasApplicableItemFilters(HarvestHandler harvestHandler, BlockPos pos, BlockState blockState) {
        List<ItemStack> droppedStacks = harvestHandler.addFilterItems(this.drone.world(), (IBlockReader)this.worldCache, pos, blockState, this.drone);
        return droppedStacks.stream().anyMatch(droppedStack -> this.progWidget.isItemValidForFilters((ItemStack)droppedStack, blockState));
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        HarvestHandler applicableHandler = this.getApplicableHandler(pos);
        if (applicableHandler != null) {
            BlockState state = this.worldCache.func_180495_p(pos);
            if (applicableHandler.canHarvest(this.drone.world(), (IBlockReader)this.worldCache, pos, state, this.drone)) {
                Consumer<PlayerEntity> damageableHoe = this.getDamageableHoe();
                if (damageableHoe != null) {
                    if (applicableHandler.harvestAndReplant(this.drone.world(), (IBlockReader)this.worldCache, pos, state, this.drone)) {
                        damageableHoe.accept((PlayerEntity)this.drone.getFakePlayer());
                    }
                } else {
                    applicableHandler.harvest(this.drone.world(), (IBlockReader)this.worldCache, pos, state, this.drone);
                }
            }
        }
        return false;
    }

    private Consumer<PlayerEntity> getDamageableHoe() {
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            HoeHandler handler = ModRegistries.HOE_HANDLERS.getValues().stream().filter(hoeHandler -> hoeHandler.test(stack)).findFirst().orElse(null);
            if (handler == null) continue;
            return handler.getConsumer(stack);
        }
        return null;
    }
}

