/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidExport<W extends ProgWidgetInventoryBase & ILiquidExport>
extends DroneAIImExBase<W> {
    public DroneAILiquidExport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.fillTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.fillTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean fillTank(BlockPos pos, boolean simulate) {
        LazyOptional cap;
        if (this.drone.getFluidTank().getFluidAmount() == 0) {
            this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.emptyDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            FluidStack exportedFluid = this.drone.getFluidTank().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (!exportedFluid.isEmpty() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(exportedFluid.getFluid())) {
                for (Direction side : Direction.field_199792_n) {
                    if (!((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side) || !this.trySide(te, side, exportedFluid, simulate)) continue;
                    return true;
                }
                this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.filledToMax", pos);
            } else {
                this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.noValidFluid");
            }
        } else if (((ILiquidExport)((Object)((ProgWidgetInventoryBase)this.progWidget))).isPlacingFluidBlocks() && (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() >= 1000) && FluidUtils.tryPourOutFluid((LazyOptional<IFluidHandler>)(cap = this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)), this.drone.world(), pos, false, false, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)) {
            if (!simulate) {
                this.decreaseCount(1000);
            }
            return true;
        }
        return false;
    }

    private boolean trySide(TileEntity te, Direction side, FluidStack fluidToExport, boolean simulate) {
        return te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(fluidHandler -> {
            int filledAmount = fluidHandler.fill(fluidToExport, IFluidHandler.FluidAction.SIMULATE);
            if (filledAmount > 0) {
                if (((ICountWidget)((Object)this.progWidget)).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(fluidHandler.fill(this.drone.getFluidTank().drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }
}

