/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DroneAILiquidImport<W extends ProgWidgetInventoryBase>
extends DroneAIImExBase<W> {
    public DroneAILiquidImport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean emptyTank(BlockPos pos, boolean simulate) {
        LazyOptional cap;
        FluidStack stack;
        if (this.drone.getFluidTank().getFluidAmount() == this.drone.getFluidTank().getCapacity()) {
            this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            Direction side;
            boolean didWork = false;
            Direction[] directionArray = Direction.field_199792_n;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side = directionArray[i]) && (didWork = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).map(handler -> this.tryImportFluid((IFluidHandler)handler, simulate)).orElse(false).booleanValue())); ++i) {
            }
            if (didWork) {
                return true;
            }
            this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        }
        if (!(((ProgWidgetInventoryBase)this.progWidget).useCount() && this.getRemainingCount() < 1000 || (stack = FluidUtils.tryPickupFluid((LazyOptional<IFluidHandler>)(cap = this.drone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)), this.drone.world(), pos, false, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || stack.getAmount() != 1000 || !((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(stack.getFluid()) || this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.SIMULATE) != 1000)) {
            if (!simulate) {
                this.decreaseCount(1000);
                FluidUtils.tryPickupFluid((LazyOptional<IFluidHandler>)cap, this.drone.world(), pos, false, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    private boolean tryImportFluid(IFluidHandler sourceHandler, boolean simulate) {
        int filledAmount;
        FluidStack importedFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (importedFluid != null && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(importedFluid.getFluid()) && (filledAmount = this.drone.getFluidTank().fill(importedFluid, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                filledAmount = Math.min(filledAmount, this.getRemainingCount());
            }
            if (!simulate) {
                this.decreaseCount(this.drone.getFluidTank().fill(sourceHandler.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
            }
            return true;
        }
        return false;
    }
}

