/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetBlockRightClick;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIRightClickBlock
extends DroneAIBlockInteraction<ProgWidgetBlockRightClick> {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();

    public DroneAIRightClickBlock(IDroneBase drone, ProgWidgetBlockRightClick widget) {
        super(drone, widget);
        drone.getFakePlayer().func_226284_e_(widget.isSneaking());
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return !this.visitedPositions.contains(pos) && (((ProgWidgetBlockRightClick)this.progWidget).isItemFilterEmpty() || DroneAIDig.isBlockValidForFilter((IBlockReader)this.drone.world(), pos, this.drone, this.progWidget));
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        this.visitedPositions.add(pos);
        this.rightClick(pos);
        if (this.drone.getFakePlayer().func_184614_ca().func_190916_E() <= 0) {
            this.drone.getFakePlayer().func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        this.drone.getInv().setStackInSlot(0, this.drone.getFakePlayer().func_184614_ca());
        return false;
    }

    private void rightClick(BlockPos pos) {
        Direction faceDir = ISidedWidget.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
        if (((ProgWidgetBlockRightClick)this.progWidget).getClickType() == IBlockRightClicker.RightClickType.CLICK_ITEM) {
            this.rightClickItem(this.drone.getFakePlayer(), pos, faceDir);
        } else {
            this.rightClickBlock(this.drone.getFakePlayer(), pos, faceDir);
        }
    }

    private void rightClickItem(FakePlayer fakePlayer, BlockPos pos, Direction faceDir) {
        ItemStack stack = fakePlayer.func_184614_ca();
        World world = fakePlayer.func_130014_f_();
        try {
            Block block;
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (Direction)faceDir);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return;
            }
            BlockRayTraceResult brtr = this.doTrace(world, pos, fakePlayer);
            if (brtr == null) {
                return;
            }
            ActionResultType ret = stack.onItemUseFirst(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
            if (ret != ActionResultType.PASS) {
                return;
            }
            if (stack.func_190926_b() || fakePlayer.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                return;
            }
            if (stack.func_77973_b() instanceof BlockItem && ((block = ((BlockItem)stack.func_77973_b()).func_179223_d()) instanceof CommandBlockBlock || block instanceof StructureBlock)) {
                return;
            }
            if (event.getUseItem() != Event.Result.DENY) {
                ItemStack copyBeforeUse = stack.func_77946_l();
                ActionResultType result = stack.func_196084_a(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr));
                if (result == ActionResultType.PASS) {
                    ActionResult rightClickResult = stack.func_77973_b().func_77659_a(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND);
                    fakePlayer.func_184611_a(Hand.MAIN_HAND, (ItemStack)rightClickResult.func_188398_b());
                }
                if (fakePlayer.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)fakePlayer, (ItemStack)copyBeforeUse, (Hand)Hand.MAIN_HAND);
                }
            }
        }
        catch (Throwable e) {
            Log.error("DroneAIBlockInteract crashed! Stacktrace: ", new Object[0]);
            e.printStackTrace();
        }
    }

    private void rightClickBlock(FakePlayer fakePlayer, BlockPos pos, Direction faceDir) {
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)fakePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)pos, (Direction)faceDir);
        if (!event.isCanceled() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY) {
            ActionResultType res;
            World world = fakePlayer.func_130014_f_();
            BlockState state = world.func_180495_p(pos);
            BlockRayTraceResult brtr = this.doTrace(world, pos, fakePlayer);
            if (brtr != null && (res = state.func_227031_a_(world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, brtr)).func_226246_a_()) {
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    private BlockRayTraceResult doTrace(World world, BlockPos pos, FakePlayer fakePlayer) {
        BlockState state = world.func_180495_p(pos);
        List l = state.func_196954_c((IBlockReader)world, pos).func_197756_d();
        if (l.isEmpty()) {
            return null;
        }
        Vector3d vec = ((AxisAlignedBB)l.get(0)).func_189972_c().func_178787_e(Vector3d.func_237491_b_((Vector3i)pos));
        BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(this.drone.getDronePos(), vec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)fakePlayer));
        if (!brtr.func_216350_a().equals((Object)pos)) {
            return null;
        }
        return brtr;
    }
}

