/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class DroneEntityAIInventoryExport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneEntityAIInventoryExport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.export(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        return this.export(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean export(BlockPos pos, boolean simulate) {
        TileEntity te = this.drone.world().func_175625_s(pos);
        if (te != null) {
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (droneStack.func_190926_b()) continue;
                if (((ProgWidgetInventoryBase)this.progWidget).isItemValidForFilters(droneStack)) {
                    for (int side = 0; side < 6; ++side) {
                        if (!((ProgWidgetInventoryBase)this.progWidget).getSides()[side]) continue;
                        droneStack = droneStack.func_77946_l();
                        int oldCount = droneStack.func_190916_E();
                        if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                            droneStack.func_190920_e(Math.min(droneStack.func_190916_E(), this.getRemainingCount()));
                        }
                        ItemStack remainder = IOHelper.insert(te, droneStack.func_77946_l(), Direction.func_82600_a((int)side), simulate);
                        int stackSize = this.drone.getInv().getStackInSlot(i).func_190916_E() - (remainder.func_190926_b() ? droneStack.func_190916_E() : droneStack.func_190916_E() - remainder.func_190916_E());
                        droneStack.func_190920_e(stackSize);
                        int exportedItems = oldCount - stackSize;
                        if (!simulate) {
                            this.drone.getInv().setStackInSlot(i, stackSize > 0 ? droneStack : ItemStack.field_190927_a);
                            this.decreaseCount(exportedItems);
                        }
                        if (!simulate || exportedItems <= 0) continue;
                        return true;
                    }
                    if (droneStack.func_190926_b() && !simulate) {
                        this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> h.addAir(-10));
                        continue;
                    }
                    this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.inventoryExport.debug.filledToMax", pos);
                    continue;
                }
                this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.inventoryExport.debug.stackdoesntPassFilter", pos);
            }
        } else {
            this.drone.addDebugEntry("pneumaticcraft.gui.progWidget.inventory.debug.noInventory", pos);
        }
        return false;
    }
}

