/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificProvider;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class LogisticsManager {
    private static final int N_PRIORITIES = 4;
    private final List<List<EntityLogisticsFrame>> logistics = new ArrayList<List<EntityLogisticsFrame>>();

    public LogisticsManager() {
        for (int i = 0; i < 4; ++i) {
            this.logistics.add(new ArrayList());
        }
    }

    public void addLogisticFrame(EntityLogisticsFrame frame) {
        this.logistics.get(frame.getPriority()).add(frame);
    }

    public PriorityQueue<LogisticsTask> getTasks(Object holdingStack) {
        ItemStack item = holdingStack instanceof ItemStack ? (ItemStack)holdingStack : ItemStack.field_190927_a;
        FluidStack fluid = holdingStack instanceof FluidStack ? (FluidStack)holdingStack : FluidStack.EMPTY;
        PriorityQueue<LogisticsTask> tasks = new PriorityQueue<LogisticsTask>();
        for (int priority = this.logistics.size() - 1; priority >= 0; --priority) {
            for (EntityLogisticsFrame requester : this.logistics.get(priority)) {
                for (int i = 0; i < priority; ++i) {
                    for (EntityLogisticsFrame provider : this.logistics.get(i)) {
                        int requestedAmount;
                        if (!provider.shouldProvideTo(priority)) continue;
                        if (!item.func_190926_b()) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, item, false);
                            if (requestedAmount > 0) {
                                ItemStack stack = item.func_77946_l();
                                stack.func_190920_e(requestedAmount);
                                tasks.add(new LogisticsTask(provider, requester, stack));
                                return tasks;
                            }
                        } else if (!fluid.isEmpty() && (requestedAmount = LogisticsManager.getRequestedAmount(requester, fluid, false)) > 0) {
                            fluid = fluid.copy();
                            fluid.setAmount(requestedAmount);
                            tasks.add(new LogisticsTask(provider, requester, fluid));
                            return tasks;
                        }
                        this.tryProvide(provider, requester, tasks, item.func_190926_b(), fluid.isEmpty());
                    }
                }
            }
        }
        return tasks;
    }

    private void tryProvide(EntityLogisticsFrame provider, EntityLogisticsFrame requester, PriorityQueue<LogisticsTask> tasks, boolean tryItems, boolean tryFluids) {
        if (provider.getCachedTileEntity() == null) {
            return;
        }
        if (tryItems) {
            provider.getCachedTileEntity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, provider.getFacing()).ifPresent(itemHandler -> {
                if (requester instanceof IProvidingInventoryListener) {
                    ((IProvidingInventoryListener)((Object)requester)).notify(new IProvidingInventoryListener.TileEntityAndFace(provider.getCachedTileEntity(), provider.getFacing()));
                }
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    int requestedAmount;
                    ItemStack providingStack = itemHandler.getStackInSlot(i);
                    if (providingStack.func_190926_b() || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack, true)) <= 0) continue;
                    ItemStack stack = providingStack.func_77946_l();
                    stack.func_190920_e(requestedAmount);
                    tasks.add(new LogisticsTask(provider, requester, stack));
                }
            });
        }
        if (tryFluids) {
            provider.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, provider.getFacing()).ifPresent(fluidHandler -> {
                int requestedAmount;
                boolean canDrain;
                FluidStack providingStack = fluidHandler.drain(16000, IFluidHandler.FluidAction.SIMULATE);
                if (!providingStack.isEmpty() && (canDrain = IntStream.range(0, fluidHandler.getTanks()).anyMatch(i -> fluidHandler.isFluidValid(i, providingStack))) && (!(provider instanceof ISpecificProvider) || ((ISpecificProvider)((Object)provider)).canProvide(providingStack)) && (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack, true)) > 0) {
                    FluidStack stack = providingStack.copy();
                    stack.setAmount(requestedAmount);
                    tasks.add(new LogisticsTask(provider, requester, stack));
                }
            });
        }
    }

    private static int getRequestedAmount(EntityLogisticsFrame requester, ItemStack providingStack, boolean honourMin) {
        int minOrderSize;
        TileEntity te = requester.getCachedTileEntity();
        if (te == null) {
            return 0;
        }
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.func_77976_d();
        int n = minOrderSize = honourMin && requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).getMinItemOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        if (requestedAmount < (providingStack = providingStack.func_77946_l()).func_190916_E()) {
            providingStack.func_190920_e(requestedAmount);
        }
        ItemStack remainder = providingStack.func_77946_l();
        remainder.func_190917_f(requester.getIncomingItems(providingStack));
        remainder = IOHelper.insert(te, remainder, requester.getFacing(), true);
        providingStack.func_190918_g(remainder.func_190916_E());
        return providingStack.func_190916_E() < minOrderSize ? 0 : Math.max(providingStack.func_190916_E(), 0);
    }

    private static int getRequestedAmount(EntityLogisticsFrame requester, FluidStack providingStack, boolean honourMin) {
        int minOrderSize;
        TileEntity te = requester.getCachedTileEntity();
        if (te == null) {
            return 0;
        }
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.getAmount();
        int n = minOrderSize = honourMin && requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).getMinFluidOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        if (requestedAmount < (providingStack = providingStack.copy()).getAmount()) {
            providingStack.setAmount(requestedAmount);
        }
        FluidStack remainder = providingStack.copy();
        remainder.grow(requester.getIncomingFluid(remainder.getFluid()));
        te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requester.getFacing()).ifPresent(fluidHandler -> {
            int fluidFilled = fluidHandler.fill(remainder, IFluidHandler.FluidAction.SIMULATE);
            if (fluidFilled > 0) {
                remainder.shrink(fluidFilled);
            }
        });
        providingStack.shrink(remainder.getAmount());
        return providingStack.getAmount() < minOrderSize ? 0 : providingStack.getAmount();
    }

    public static class LogisticsTask
    implements Comparable<LogisticsTask> {
        public final EntityLogisticsFrame provider;
        public final EntityLogisticsFrame requester;
        public final ItemStack transportingItem;
        public final FluidStack transportingFluid;

        LogisticsTask(EntityLogisticsFrame provider, EntityLogisticsFrame requester, @Nonnull ItemStack transportingItem) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = transportingItem;
            this.transportingFluid = FluidStack.EMPTY;
        }

        LogisticsTask(EntityLogisticsFrame provider, EntityLogisticsFrame requester, FluidStack transportingFluid) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = ItemStack.field_190927_a;
            this.transportingFluid = transportingFluid;
        }

        void informRequester() {
            if (!this.transportingItem.func_190926_b()) {
                this.requester.informIncomingStack(this.transportingItem);
            } else {
                this.requester.informIncomingStack(this.transportingFluid);
            }
        }

        public boolean isStillValid(Object stack) {
            if (stack instanceof ItemStack) {
                if (!this.transportingItem.func_190926_b()) {
                    int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (ItemStack)stack, false);
                    return requestedAmount == ((ItemStack)stack).func_190916_E();
                }
            } else if (stack instanceof FluidStack) {
                if (!this.transportingFluid.isEmpty()) {
                    int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (FluidStack)stack, false);
                    return requestedAmount == ((FluidStack)stack).getAmount();
                }
            } else {
                throw new IllegalArgumentException("arg must be ItemStack or FluidStack! " + stack);
            }
            return false;
        }

        @Override
        public int compareTo(LogisticsTask task) {
            int value = !this.transportingItem.func_190926_b() ? this.transportingItem.func_190916_E() * 100 : this.transportingFluid.getAmount();
            int otherValue = !task.transportingItem.func_190926_b() ? task.transportingItem.func_190916_E() * 100 : task.transportingFluid.getAmount();
            return otherValue - value;
        }
    }
}

