/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorFrame;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockElevatorFrame
extends BlockPneumaticCraft
implements IWaterLoggable {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final VoxelShape MOSTLY_FULL = Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    private static final BooleanProperty NE = BooleanProperty.func_177716_a((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.func_177716_a((String)"se");
    private static final BooleanProperty SW = BooleanProperty.func_177716_a((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.func_177716_a((String)"nw");

    public BlockElevatorFrame() {
        super(ModBlocks.defaultProps());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220082_b(BlockState newState, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(newState, world, pos, oldState, isMoving);
        TileEntityElevatorBase elevatorBase = BlockElevatorFrame.getElevatorTE((IBlockReader)world, pos);
        if (elevatorBase != null) {
            elevatorBase.updateMaxElevatorHeight();
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NE, SW, SE, NW, BlockStateProperties.field_208198_y});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        boolean[] connected = this.getConnections((IBlockReader)ctx.func_195991_k(), ctx.func_195995_a());
        FluidState fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(ctx).func_206870_a((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).func_206870_a((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).func_206870_a((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).func_206870_a((Property)NW, (Comparable)Boolean.valueOf(connected[3]))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        boolean[] connected = this.getConnections((IBlockReader)worldIn, currentPos);
        for (Corner corner : Corner.values()) {
            stateIn = (BlockState)stateIn.func_206870_a((Property)corner.prop, (Comparable)Boolean.valueOf(connected[corner.ordinal()]));
        }
        return stateIn;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityElevatorFrame.class;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.getShapePrivate(state, world, pos, selectionContext, false);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapePrivate(state, worldIn, pos, context, true);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return this.getCachedShape(state).func_197766_b() ? BlockRenderType.INVISIBLE : super.func_149645_b(state);
    }

    private VoxelShape getShapePrivate(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext, boolean collision) {
        if (selectionContext.func_216375_a(this.func_199767_j()) && !collision) {
            return MOSTLY_FULL;
        }
        VoxelShape shape = this.getCachedShape(state);
        float blockHeight = this.getElevatorBlockHeight(world, pos);
        if (blockHeight > 0.0f && blockHeight <= 1.0f) {
            float minY = Math.max(0.0f, blockHeight - 0.06125f) * 16.0f;
            float maxY = blockHeight * 16.0f;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.001, (double)minY, (double)0.001, (double)15.999, (double)maxY, (double)15.999));
        } else if (blockHeight > 1.0f) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        }
        return shape;
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.func_177229_b((Property)NE) != false ? 1 : 0) | ((Boolean)state.func_177229_b((Property)SE) != false ? 2 : 0) | ((Boolean)state.func_177229_b((Property)SW) != false ? 4 : 0) | ((Boolean)state.func_177229_b((Property)NW) != false ? 8 : 0);
        if (SHAPE_CACHE[shapeIdx] == null) {
            VoxelShape shape = VoxelShapes.func_197880_a();
            for (Corner corner : Corner.values()) {
                if (((Boolean)state.func_177229_b((Property)corner.prop)).booleanValue()) continue;
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)corner.shape);
            }
            BlockElevatorFrame.SHAPE_CACHE[shapeIdx] = shape;
        }
        return SHAPE_CACHE[shapeIdx];
    }

    private boolean[] getConnections(IBlockReader world, BlockPos pos) {
        boolean[] res = new boolean[4];
        boolean frameXPos = world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameXNeg = world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZPos = world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZNeg = world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get();
        res[Corner.SE.ordinal()] = frameXPos || frameZPos;
        res[Corner.NE.ordinal()] = frameXPos || frameZNeg;
        res[Corner.SW.ordinal()] = frameXNeg || frameZPos;
        res[Corner.NW.ordinal()] = frameXNeg || frameZNeg;
        return res;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        TileEntityElevatorBase te = BlockElevatorFrame.getElevatorTE((IBlockReader)world, pos);
        if (te != null && te.oldExtension != te.extension) {
            if (Math.abs(entity.func_226278_cu_() - (double)((float)te.func_174877_v().func_177956_o() + te.extension)) < 2.5) {
                AxisAlignedBB box = entity.func_174813_aQ();
                int x = te.func_174877_v().func_177958_n();
                int z = te.func_174877_v().func_177952_p();
                if (box.field_72340_a < (double)x - 0.1) {
                    entity.func_70024_g(0.02, 0.0, 0.0);
                } else if (box.field_72336_d > (double)x + 1.1) {
                    entity.func_70024_g(-0.02, 0.0, 0.0);
                } else if (box.field_72339_c < (double)z - 0.1) {
                    entity.func_70024_g(0.0, 0.0, 0.02);
                } else if (box.field_72334_f > (double)z + 1.1) {
                    entity.func_70024_g(0.0, 0.0, -0.02);
                }
                entity.func_70107_b(entity.func_226277_ct_(), (double)((float)(te.func_174877_v().func_177956_o() + 1) + te.extension), entity.func_226281_cx_());
            }
            entity.field_70143_R = 0.0f;
        }
    }

    static TileEntityElevatorBase getElevatorTE(IBlockReader world, BlockPos pos) {
        while (world.func_180495_p(pos = pos.func_177972_a(Direction.DOWN)).func_177230_c() != ModBlocks.ELEVATOR_BASE.get()) {
            if (world.func_180495_p(pos).func_177230_c() == ModBlocks.ELEVATOR_FRAME.get() && pos.func_177956_o() > 0) continue;
            return null;
        }
        return (TileEntityElevatorBase)world.func_175625_s(pos);
    }

    private float getElevatorBlockHeight(IBlockReader world, BlockPos pos) {
        TileEntityElevatorBase te = BlockElevatorFrame.getElevatorTE(world, pos);
        return te == null ? 0.0f : Math.max(te.extension - (float)(pos.func_177956_o() - te.func_174877_v().func_177956_o()) + 1.0f, 0.0f);
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityElevatorBase elevatorBase = BlockElevatorFrame.getElevatorTE((IBlockReader)world, pos);
        if (elevatorBase != null) {
            elevatorBase.updateMaxElevatorHeight();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState below = worldIn.func_180495_p(pos.func_177977_b());
        return below.func_177230_c() == this || below.func_177230_c() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        if (!player.func_213453_ef() && player.func_184586_b(hand).func_77973_b() == this.func_199767_j()) {
            if (!world.field_72995_K) {
                BlockPos.Mutable mPos = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                int worldHeight = world.func_230315_m_().func_241513_m_();
                while (mPos.func_177956_o() < worldHeight && world.func_180495_p((BlockPos)mPos).func_177230_c() == this) {
                    mPos.func_189536_c(Direction.UP);
                }
                if (mPos.func_177956_o() < worldHeight && world.func_180495_p((BlockPos)mPos).isAir((IBlockReader)world, (BlockPos)mPos)) {
                    world.func_175656_a((BlockPos)mPos, this.func_176223_P());
                    float pitch = Math.min(1.5f, (float)(mPos.func_177956_o() - pos.func_177956_o()) * 0.05f + 1.0f);
                    world.func_184133_a(null, (BlockPos)mPos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, pitch);
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, brtr);
    }

    static /* synthetic */ BooleanProperty access$000() {
        return NE;
    }

    static /* synthetic */ BooleanProperty access$100() {
        return SE;
    }

    static /* synthetic */ BooleanProperty access$200() {
        return SW;
    }

    static /* synthetic */ BooleanProperty access$300() {
        return NW;
    }

    private static enum Corner {
        NE(1, -1, BlockElevatorFrame.access$000(), Block.func_208617_a((double)14.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)1.5)),
        SE(1, 1, BlockElevatorFrame.access$100(), Block.func_208617_a((double)14.5, (double)0.0, (double)14.5, (double)15.5, (double)16.0, (double)15.5)),
        SW(-1, 1, BlockElevatorFrame.access$200(), Block.func_208617_a((double)0.5, (double)0.0, (double)14.5, (double)1.5, (double)16.0, (double)15.5)),
        NW(-1, -1, BlockElevatorFrame.access$300(), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)1.5, (double)16.0, (double)1.5));

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Corner(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }
}

