/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ModuleLogistics
extends TubeModule
implements INetworkedModule {
    private EntityLogisticsFrame cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;

    public ModuleLogistics(ItemTubeModule itemTubeModule) {
        super(itemTubeModule);
    }

    public int getTicksSinceAction() {
        return this.ticksSinceAction;
    }

    public int getTicksSinceNotEnoughAir() {
        return this.ticksSinceNotEnoughAir;
    }

    @Override
    public double getWidth() {
        return 13.0;
    }

    @Override
    protected double getHeight() {
        return 4.5;
    }

    @Override
    public int getColorChannel() {
        return this.colorChannel;
    }

    @Override
    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powered", this.powered);
        nbt.func_74774_a("colorChannel", (byte)this.colorChannel);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.func_74767_n("powered");
        this.colorChannel = nbt.func_74771_c("colorChannel");
    }

    public EntityLogisticsFrame getFrame() {
        ISemiBlock semiBlock;
        if (this.cachedFrame == null && (semiBlock = SemiblockTracker.getInstance().getSemiblock(this.getTube().func_145831_w(), this.getTube().func_174877_v().func_177972_a(this.dir))) instanceof EntityLogisticsFrame) {
            this.cachedFrame = (EntityLogisticsFrame)semiBlock;
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        DyeColor color = DyeColor.getColor((ItemStack)player.func_184586_b(hand));
        if (color != null) {
            int colorId = color.func_196059_a();
            if (!player.field_70170_p.field_72995_K) {
                this.setColorChannel(colorId);
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticsModule(this, 0), this.getTube().func_145831_w());
                if (PNCConfig.Common.General.useUpDyesWhenColoring && !player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.onActivated(player, hand);
    }

    @Override
    public void update() {
        super.update();
        if (this.cachedFrame != null && !this.cachedFrame.isValid()) {
            this.cachedFrame = null;
        }
        if (!this.getTube().func_145831_w().field_72995_K) {
            if (this.powered != (double)this.getTube().getPressure() >= PNCConfig.Common.Logistics.minPressure) {
                this.powered = !this.powered;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticsModule(this, 0), this.getTube().func_145831_w());
            }
            if (--this.ticksUntilNextCycle <= 0) {
                LogisticsManager manager = new LogisticsManager();
                HashMap<Integer, ModuleLogistics> frame2module = new HashMap<Integer, ModuleLogistics>();
                HashMap<Integer, Direction> frame2side = new HashMap<Integer, Direction>();
                for (TubeModule module : ModuleNetworkManager.getInstance(this.getTube().func_145831_w()).getConnectedModules(this)) {
                    ModuleLogistics logistics;
                    if (!(module instanceof ModuleLogistics) || (logistics = (ModuleLogistics)module).getColorChannel() != this.getColorChannel()) continue;
                    logistics.ticksUntilNextCycle = 100;
                    if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                    frame2side.put(logistics.getFrame().func_145782_y(), logistics.getFrame().getFacing());
                    logistics.getFrame().setFacing(logistics.dir.func_176734_d());
                    frame2module.put(logistics.getFrame().func_145782_y(), logistics);
                    manager.addLogisticFrame(logistics.getFrame());
                }
                PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null);
                for (LogisticsManager.LogisticsTask task : tasks) {
                    if (!task.isStillValid(task.transportingItem.func_190926_b() ? task.transportingFluid : task.transportingItem)) continue;
                    if (!task.transportingItem.func_190926_b()) {
                        this.handleItems((ModuleLogistics)frame2module.get(task.provider.func_145782_y()), (ModuleLogistics)frame2module.get(task.requester.func_145782_y()), task);
                        continue;
                    }
                    this.handleFluids((ModuleLogistics)frame2module.get(task.provider.func_145782_y()), (ModuleLogistics)frame2module.get(task.requester.func_145782_y()), task);
                }
                frame2side.forEach((id, dir) -> {
                    Entity e = this.getTube().func_145831_w().func_73045_a(id.intValue());
                    if (e instanceof EntityLogisticsFrame) {
                        ((EntityLogisticsFrame)e).setFacing((Direction)dir);
                    }
                });
            }
        } else {
            if (this.ticksSinceAction >= 0) {
                ++this.ticksSinceAction;
                if (this.ticksSinceAction > 3) {
                    this.ticksSinceAction = -1;
                }
            }
            if (this.ticksSinceNotEnoughAir >= 0) {
                ++this.ticksSinceNotEnoughAir;
                if (this.ticksSinceNotEnoughAir > 20) {
                    this.ticksSinceNotEnoughAir = -1;
                }
            }
        }
    }

    private void handleItems(ModuleLogistics providingModule, ModuleLogistics requestingModule, LogisticsManager.LogisticsTask task) {
        IOHelper.getInventoryForTE(task.requester.getCachedTileEntity(), requestingModule.dir.func_176734_d()).ifPresent(requestingHandler -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)task.transportingItem, (boolean)true);
            if (remainder.func_190916_E() != task.transportingItem.func_190916_E()) {
                ItemStack toBeExtracted = task.transportingItem.func_77946_l();
                toBeExtracted.func_190918_g(remainder.func_190916_E());
                IOHelper.getInventoryForTE(task.provider.getCachedTileEntity(), providingModule.dir.func_176734_d()).ifPresent(providingHandler -> this.tryItemTransfer(providingModule, requestingModule, (IItemHandler)providingHandler, (IItemHandler)requestingHandler, toBeExtracted));
            }
        });
    }

    private void tryItemTransfer(ModuleLogistics providingModule, ModuleLogistics requestingModule, IItemHandler providingHandler, IItemHandler requestingHandler, ItemStack toTransfer) {
        ItemStack extractedStack = IOHelper.extract(providingHandler, toTransfer, IOHelper.ExtractCount.UP_TO, true, requestingModule.getFrame().isMatchNBT());
        if (extractedStack.func_190926_b()) {
            return;
        }
        IAirHandlerMachine receiverAirHandler = (IAirHandlerMachine)requestingModule.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new);
        int airUsed = (int)(PNCConfig.Common.Logistics.itemTransportCost * (double)extractedStack.func_190916_E() * PneumaticCraftUtils.distBetween((Vector3i)providingModule.getTube().func_174877_v(), (Vector3i)requestingModule.getTube().func_174877_v()));
        if (airUsed > receiverAirHandler.getAir()) {
            double scaleBack = (double)receiverAirHandler.getAir() / (double)airUsed;
            extractedStack.func_190920_e((int)((double)extractedStack.func_190916_E() * scaleBack));
            airUsed = (int)((double)airUsed * scaleBack);
        }
        if (extractedStack.func_190926_b()) {
            this.sendModuleUpdate(providingModule, false);
            this.sendModuleUpdate(requestingModule, false);
        } else {
            this.sendModuleUpdate(providingModule, true);
            this.sendModuleUpdate(requestingModule, true);
            receiverAirHandler.addAir(-airUsed);
            IOHelper.extract(providingHandler, extractedStack, IOHelper.ExtractCount.EXACT, false, requestingModule.getFrame().isMatchNBT());
            ItemHandlerHelper.insertItem((IItemHandler)requestingHandler, (ItemStack)extractedStack, (boolean)false);
            this.ticksUntilNextCycle = 20;
        }
    }

    private void handleFluids(ModuleLogistics providingModule, ModuleLogistics requestingModule, LogisticsManager.LogisticsTask task) {
        task.requester.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requestingModule.dir.func_176734_d()).ifPresent(requestingHandler -> {
            int amountFilled = requestingHandler.fill(task.transportingFluid, IFluidHandler.FluidAction.SIMULATE);
            if (amountFilled > 0) {
                FluidStack drainingFluid = task.transportingFluid.copy();
                drainingFluid.setAmount(amountFilled);
                task.provider.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, providingModule.dir.func_176734_d()).ifPresent(providingHandler -> this.tryFluidTransfer(providingModule, (IFluidHandler)providingHandler, requestingModule, (IFluidHandler)requestingHandler, drainingFluid));
            }
        });
    }

    private void tryFluidTransfer(ModuleLogistics providingModule, IFluidHandler providingHandler, ModuleLogistics requestingModule, IFluidHandler requestingHandler, FluidStack toTransfer) {
        FluidStack extractedFluid = providingHandler.drain(toTransfer, IFluidHandler.FluidAction.SIMULATE);
        if (extractedFluid.isEmpty()) {
            return;
        }
        IAirHandlerMachine receiverAirHandler = (IAirHandlerMachine)requestingModule.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new);
        double airUsed = PNCConfig.Common.Logistics.fluidTransportCost * (double)extractedFluid.getAmount() * PneumaticCraftUtils.distBetween((Vector3i)providingModule.getTube().func_174877_v(), (Vector3i)requestingModule.getTube().func_174877_v());
        if (airUsed > (double)receiverAirHandler.getAir()) {
            double scaleBack = (double)receiverAirHandler.getAir() / airUsed;
            toTransfer.setAmount((int)((double)extractedFluid.getAmount() * scaleBack));
            airUsed *= scaleBack;
        }
        if (toTransfer.isEmpty()) {
            this.sendModuleUpdate(providingModule, false);
            this.sendModuleUpdate(requestingModule, false);
        } else {
            this.sendModuleUpdate(providingModule, true);
            this.sendModuleUpdate(requestingModule, true);
            receiverAirHandler.addAir((int)(-airUsed));
            requestingHandler.fill(providingHandler.drain(toTransfer, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            this.ticksUntilNextCycle = 20;
        }
    }

    private void sendModuleUpdate(ModuleLogistics module, boolean enoughAir) {
        NetworkHandler.sendToAllAround(new PacketUpdateLogisticsModule(module, enoughAir ? 1 : 2), module.getTube().func_145831_w());
    }

    @Override
    public void addInfo(List<ITextComponent> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "pneumaticcraft.waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "pneumaticcraft.waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "pneumaticcraft.waila.logisticsModule.powered" : "pneumaticcraft.waila.logisticsModule.noPower"));
        curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.hud.msg.state", new Object[0]).func_240702_b_(": ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate(status, new Object[0])));
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }
}

