/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.living;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.items.ItemStackHandler;

public class EntityAmadrone
extends EntityDrone {
    private static ItemStack amadroneStack = ItemStack.field_190927_a;
    private ResourceLocation handlingOffer;
    private int offerTimes;
    private ItemStack usedTablet = ItemStack.field_190927_a;
    private String buyingPlayer;
    private AmadronAction amadronAction;

    public EntityAmadrone(EntityType<? extends EntityDrone> type, World world) {
        super(type, world, null);
        this.func_200203_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.drone.amadronDeliveryDrone"));
    }

    public static EntityAmadrone makeAmadrone(World world, BlockPos pos) {
        EntityAmadrone drone = new EntityAmadrone((EntityType<? extends EntityDrone>)((EntityType)ModEntities.AMADRONE.get()), world);
        drone.readFromItemStack(EntityAmadrone.getAmadroneStack());
        int startY = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos.func_177982_a(30, 0, 0)).func_177956_o() + 27 + world.field_73012_v.nextInt(6);
        drone.func_70107_b(pos.func_177958_n() + 27 + world.field_73012_v.nextInt(6), startY, pos.func_177952_p() + world.field_73012_v.nextInt(6) - 3);
        return drone;
    }

    private static ItemStack getAmadroneStack() {
        if (amadroneStack.func_190926_b()) {
            amadroneStack = new ItemStack((IItemProvider)ModItems.DRONE.get());
            ItemStackHandler upgradeInv = new ItemStackHandler(9);
            upgradeInv.setStackInSlot(0, EnumUpgrade.SPEED.getItemStack(10));
            upgradeInv.setStackInSlot(1, EnumUpgrade.INVENTORY.getItemStack(35));
            upgradeInv.setStackInSlot(2, EnumUpgrade.ITEM_LIFE.getItemStack(10));
            upgradeInv.setStackInSlot(3, EnumUpgrade.SECURITY.getItemStack());
            UpgradableItemUtils.setUpgrades(amadroneStack, upgradeInv);
            ((IAirHandlerItem)amadroneStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).addAir(100000);
        }
        return amadroneStack;
    }

    public void setHandlingOffer(ResourceLocation offerId, int times, @Nonnull ItemStack usedTablet, String buyingPlayer, AmadronAction amadronAction) {
        this.handlingOffer = offerId;
        this.offerTimes = times;
        this.usedTablet = usedTablet.func_77946_l();
        this.buyingPlayer = buyingPlayer;
        this.amadronAction = amadronAction;
    }

    public ResourceLocation getHandlingOffer() {
        return this.handlingOffer;
    }

    public AmadronAction getAmadronAction() {
        return this.amadronAction;
    }

    public int getOfferTimes() {
        return this.offerTimes;
    }

    public ItemStack getUsedTablet() {
        return this.usedTablet;
    }

    public String getBuyingPlayer() {
        return this.buyingPlayer;
    }

    @Override
    public boolean shouldDropAsItem() {
        return false;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    @Override
    protected void func_213337_cE() {
    }

    @Override
    public int getUpgrades(EnumUpgrade upgrade) {
        switch (upgrade) {
            case SECURITY: {
                return 1;
            }
            case ITEM_LIFE: 
            case SPEED: {
                return 10;
            }
            case INVENTORY: {
                return 35;
            }
        }
        return 0;
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.handlingOffer != null) {
            CompoundNBT subTag = new CompoundNBT();
            subTag.func_74778_a("offerId", this.handlingOffer.toString());
            subTag.func_74768_a("offerTimes", this.offerTimes);
            subTag.func_74778_a("buyingPlayer", this.buyingPlayer);
            if (!this.usedTablet.func_190926_b()) {
                subTag.func_218657_a("usedTablet", (INBT)this.usedTablet.func_77955_b(new CompoundNBT()));
            }
            subTag.func_74778_a("amadronAction", this.amadronAction.toString());
            tag.func_218657_a("amadron", (INBT)subTag);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("amadron")) {
            CompoundNBT subTag = tag.func_74775_l("amadron");
            this.handlingOffer = new ResourceLocation(subTag.func_74779_i("offerId"));
            this.usedTablet = ItemStack.func_199557_a((CompoundNBT)subTag.func_74775_l("usedTablet"));
            this.offerTimes = subTag.func_74762_e("offerTimes");
            this.buyingPlayer = subTag.func_74779_i("buyingPlayer");
            this.amadronAction = AmadronAction.valueOf(subTag.func_74779_i("amadronAction"));
        }
    }

    public static enum AmadronAction {
        TAKING_PAYMENT,
        RESTOCKING;

    }
}

