/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.entity.semiblock.EntityLogisticsFrame;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2Integration;
import me.desht.pneumaticcraft.common.thirdparty.ae2.AE2RequesterIntegration;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class EntityLogisticsRequester
extends EntityLogisticsFrame
implements ISpecificRequester,
IProvidingInventoryListener {
    private static final DataParameter<Boolean> AE2_ENABLED = EntityDataManager.func_187226_a(EntityLogisticsRequester.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String NBT_AE2_INTEGRATION = "AE2_Integration";
    private int minItems = 1;
    private int minFluid = 1;
    private AE2RequesterIntegration ae2requester = null;

    public EntityLogisticsRequester(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        if (AE2Integration.isAvailable()) {
            this.func_184212_Q().func_187214_a(AE2_ENABLED, (Object)false);
        }
    }

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    protected ContainerType<?> getContainerType() {
        return (ContainerType)ModContainers.LOGISTICS_FRAME_REQUESTER.get();
    }

    @Override
    public int getMinItemOrderSize() {
        return this.minItems;
    }

    @Override
    public void setMinItemOrderSize(int minItems) {
        this.minItems = minItems;
    }

    @Override
    public int getMinFluidOrderSize() {
        return this.minFluid;
    }

    @Override
    public void setMinFluidOrderSize(int minFluid) {
        this.minFluid = minFluid;
    }

    @Override
    protected void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (AE2Integration.isAvailable()) {
            this.setAE2enabled(tag.func_74767_n(NBT_AE2_INTEGRATION));
        }
    }

    @Override
    public CompoundNBT serializeNBT(CompoundNBT tag) {
        tag = super.serializeNBT(tag);
        if (AE2Integration.isAvailable()) {
            tag.func_74757_a(NBT_AE2_INTEGRATION, this.isAE2enabled());
        }
        return tag;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    public boolean supportsBlacklisting() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && AE2Integration.isAvailable()) {
            this.getAE2integration().maybeCheckForInterface();
        }
    }

    @Override
    public void notify(IProvidingInventoryListener.TileEntityAndFace teAndFace) {
        if (AE2Integration.isAvailable()) {
            this.getAE2integration().maybeAddTE(teAndFace);
        }
    }

    @Override
    protected void onBroken() {
        super.onBroken();
        if (AE2Integration.isAvailable()) {
            this.getAE2integration().shutdown();
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (tag.equals("ae2") && AE2Integration.isAvailable()) {
            this.setAE2enabled(!this.isAE2enabled());
            this.getAE2integration().setEnabled(this.isAE2enabled());
        }
    }

    @Override
    public int amountRequested(ItemStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return IOHelper.getInventoryForTE(this.getCachedTileEntity(), this.getFacing()).map(itemHandler -> {
                int count = 0;
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack s = itemHandler.getStackInSlot(i);
                    if (s.func_190926_b() || !this.getItemFilterHandler().matchOneItem(stack, s)) continue;
                    count += s.func_190916_E();
                }
                return Math.max(0, Math.min(stack.func_190916_E(), totalRequestingAmount - (count += this.getIncomingItems(stack))));
            }).orElse(0);
        }
        return 0;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            return this.getCachedTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getFacing()).map(fluidHandler -> {
                int count = 0;
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack contents = fluidHandler.getFluidInTank(i);
                    if (contents.getFluid() != stack.getFluid()) continue;
                    count += contents.getAmount();
                }
                return Math.max(0, Math.min(stack.getAmount(), totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
            }).orElse(0);
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        return this.getItemFilterHandler().getMatchedCount(stack);
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getFluidFilter(i);
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.getAmount();
        }
        return requesting;
    }

    private void setAE2enabled(boolean enabled) {
        this.func_184212_Q().func_187227_b(AE2_ENABLED, (Object)enabled);
    }

    public boolean isAE2enabled() {
        return AE2Integration.isAvailable() && (Boolean)this.func_184212_Q().func_187225_a(AE2_ENABLED) != false;
    }

    public AE2RequesterIntegration getAE2integration() {
        if (this.ae2requester == null) {
            this.ae2requester = new AE2RequesterIntegration(this);
        }
        return this.ae2requester;
    }
}

