/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.Iterator;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.EntityTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.ai.EntityAINoAIWhenRidingDrone;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHacking;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.hacking.entity.HackableEnderman;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipeImpl;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.DeferredTaskManager;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;

public class EventHandlerPneumaticCraft {
    @SubscribeEvent
    public void handleFuelEvent(FurnaceFuelBurnTimeEvent event) {
        FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fluidStack -> {
            ResourceLocation name = fluidStack.getFluid().getRegistryName();
            if ("pneumaticcraft".equals(name.func_110624_b())) {
                int value = PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(fluidStack.getFluid());
                event.setBurnTime(value > 0 ? (int)((double)value * PNCConfig.Common.General.fuelBucketEfficiency) : -1);
            }
        });
    }

    @SubscribeEvent
    public void explosionCraftingEvent(ExplosionEvent.Detonate event) {
        if (!PNCConfig.Common.Recipes.explosionCrafting || event.getWorld().field_72995_K) {
            return;
        }
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof ItemEntity) || !entity.func_70089_S() || (stack = ((ItemEntity)entity).func_92059_d()).func_190926_b()) continue;
            boolean firstItem = true;
            for (ItemStack result : ExplosionCraftingRecipeImpl.tryToCraft(event.getWorld(), stack)) {
                if (firstItem) {
                    ((ItemEntity)entity).func_92058_a(result);
                    iterator.remove();
                    firstItem = false;
                    continue;
                }
                PneumaticCraftUtils.dropItemOnGround(result, event.getWorld(), entity.func_233580_cy_());
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof IDroneBase) {
            MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent((IDroneBase)event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof MobEntity) {
            MobEntity mob = (MobEntity)event.getEntity();
            DeferredTaskManager.getInstance().scheduleTask(() -> {
                if (mob.func_70089_S()) {
                    mob.field_70714_bg.func_75776_a(Integer.MIN_VALUE, (Goal)new EntityAINoAIWhenRidingDrone(mob));
                }
            });
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(PneumaticCraftUtils.RL("hacking"), (ICapabilityProvider)new CapabilityHacking.Provider());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEnderTeleport(EnderTeleportEvent event) {
        Entity e = event.getEntity();
        if (!HackableEnderman.onEndermanTeleport(e)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        RayTraceResult rtr = event.getTarget();
        if (rtr != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
            Block b = event.getWorld().func_180495_p(brtr.func_216350_a()).func_177230_c();
            if (b instanceof FlowingFluidBlock) {
                FlowingFluid fluid = ((FlowingFluidBlock)b).getFluid();
                if (TileEntityRefineryController.isInputFluidValid(event.getWorld(), (Fluid)fluid, 4) && event.getPlayer() instanceof ServerPlayerEntity) {
                    AdvancementTriggers.OIL_BUCKET.trigger((ServerPlayerEntity)event.getPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.RightClickEmpty) {
            return;
        }
        ItemStack heldItem = event.getPlayer().func_184586_b(event.getHand());
        BlockState interactedBlockState = event.getWorld().func_180495_p(event.getPos());
        Block interactedBlock = interactedBlockState.func_177230_c();
        if (!(event.getPlayer().func_184812_l_() && event.getPlayer().func_195051_bN().func_197034_c(2) || event.getWorld() == null || event.getWorld().field_72995_K || interactedBlock == ModBlocks.SECURITY_STATION.get() && !(event instanceof PlayerInteractEvent.LeftClickBlock))) {
            boolean tryingToPlaceSecurityStation = heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() == ModBlocks.SECURITY_STATION.get();
            int blockingStations = TileEntitySecurityStation.getProtectingSecurityStations(event.getPlayer(), event.getPos(), true, tryingToPlaceSecurityStation);
            if (blockingStations > 0) {
                event.setCanceled(true);
                event.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[]{blockingStations}), false);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (!event.isCanceled() && state.func_177230_c() instanceof IPneumaticWrenchable) {
            if (event.getHand() == Hand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getFace(), event.getHand()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getTarget() instanceof IPneumaticWrenchable) {
            if (event.getHand() == Hand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(Hand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getPlayer().func_184586_b(event.getHand()))) {
                if (event.getWorld().field_72995_K) {
                    NetworkHandler.sendToServer(new PacketModWrenchBlock(event.getPos(), event.getHand(), event.getTarget().func_145782_y()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        if (event.getUsername().equals("Quetzz") && event.getMessage().equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187558_ak, SoundCategory.NEUTRAL, event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_(), 1.0f, 1.0f, true), event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof World) {
            World world = (World)event.getWorld();
            if (!world.field_72995_K) {
                ModuleNetworkManager.getInstance(world).invalidateCache();
            }
        }
    }

    @SubscribeEvent
    public void onEntityTracking(EntityTrackEvent event) {
        if (event.trackingEntity instanceof EntityProgrammableController) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof TileEntityProgrammer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (PNCConfig.Common.General.enableDungeonLoot) {
            String prefix = "minecraft:chests/";
            String name = event.getName().toString();
            if (name.startsWith(prefix)) {
                String file;
                switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                    case "abandoned_mineshaft": 
                    case "desert_pyramid": 
                    case "jungle_temple": 
                    case "simple_dungeon": 
                    case "stronghold_corridor": 
                    case "village_blacksmith": {
                        event.getTable().addPool(this.buildLootPool("simple_dungeon_loot"));
                        break;
                    }
                }
            }
        }
    }

    private LootPool buildLootPool(String name) {
        return LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)PneumaticCraftUtils.RL("inject/" + name)).func_216086_a(1)).bonusRolls(0.0f, 1.0f).name("pneumaticcraft_inject").func_216044_b();
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            if (event.getSlot() == EquipmentSlotType.MAINHAND) {
                if (event.getTo().func_77973_b() == ModItems.MINIGUN.get()) {
                    NBTUtils.initNBTTagCompound(event.getTo());
                    event.getTo().func_77978_p().func_74768_a("owningPlayerId", event.getEntityLiving().func_145782_y());
                } else if (event.getFrom().func_77973_b() == ModItems.MINIGUN.get()) {
                    NBTUtils.initNBTTagCompound(event.getFrom());
                    event.getFrom().func_77978_p().func_82580_o("owningPlayerId");
                }
            } else if (event.getSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR) {
                ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
                for (ItemStack stack : player.func_184193_aE()) {
                    if (stack.func_77973_b() instanceof ItemPneumaticArmor) continue;
                    return;
                }
                AdvancementTriggers.PNEUMATIC_ARMOR.trigger(player);
            }
        }
    }

    @SubscribeEvent
    public void entityMounting(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityMounting() instanceof EntityDrone && (event.getEntityBeingMounted() instanceof AbstractMinecartEntity || event.getEntityBeingMounted() instanceof BoatEntity) && !event.getEntityBeingMounted().func_233570_aj_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerJoinedWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            JetBootsStateTracker.getTracker((PlayerEntity)player).informOtherPlayers(player);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        PneumaticHelmetRegistry.getInstance().resolveBlockTags((ITagCollection<Block>)event.getTagManager().func_241835_a());
    }
}

