/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.block;

import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;

public class HackableMobSpawner
implements IHackableBlock {
    @Override
    public ResourceLocation getHackableId() {
        return PneumaticCraftUtils.RL("mob_spawner");
    }

    @Override
    public boolean canHack(IBlockReader world, BlockPos pos, PlayerEntity player) {
        return !HackableMobSpawner.isHacked(world, pos);
    }

    public static boolean isHacked(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof MobSpawnerTileEntity && ((MobSpawnerTileEntity)te).func_145881_a().field_98289_l == 0;
    }

    @Override
    public void addInfo(IBlockReader world, BlockPos pos, List<String> curInfo, PlayerEntity player) {
        curInfo.add("pneumaticcraft.armor.hacking.result.neutralize");
    }

    @Override
    public void addPostHackInfo(IBlockReader world, BlockPos pos, List<String> curInfo, PlayerEntity player) {
        curInfo.add("pneumaticcraft.armor.hacking.finished.neutralized");
    }

    @Override
    public int getHackTime(IBlockReader world, BlockPos pos, PlayerEntity player) {
        return 200;
    }

    @Override
    public void onHackComplete(World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            CompoundNBT tag = new CompoundNBT();
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                te.func_189515_b(tag);
                tag.func_74777_a("RequiredPlayerRange", (short)0);
                te.func_230337_a_(te.func_195044_w(), tag);
                BlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    @Override
    public boolean afterHackTick(IBlockReader world, BlockPos pos) {
        AbstractSpawner spawner = ((MobSpawnerTileEntity)world.func_175625_s(pos)).func_145881_a();
        spawner.field_98284_d = spawner.field_98287_c;
        spawner.field_98286_b = 10;
        return false;
    }
}

