/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.heat.IHeatRegistry;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicTicking;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;

public enum HeatExchangerManager implements IHeatRegistry
{
    INSTANCE;


    public static HeatExchangerManager getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getLogic(IWorld world, BlockPos pos, Direction side) {
        return this.getLogic(world, pos, side, IHeatExchangerLogic.ALL_BLOCKS);
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getLogic(IWorld world, BlockPos pos, Direction side, BiPredicate<IWorld, BlockPos> blockFilter) {
        if (!world.isAreaLoaded(pos, 0)) {
            return LazyOptional.empty();
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).isPresent()) {
            return te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side);
        }
        if (!blockFilter.test(world, pos)) {
            return LazyOptional.empty();
        }
        if (world.func_175623_d(pos)) {
            return LazyOptional.of(() -> HeatExchangerLogicAmbient.atPosition(world, pos));
        }
        BlockState state = world.func_180495_p(pos);
        BlockHeatProperties.CustomHeatEntry entry = BlockHeatProperties.getInstance().getCustomHeatEntry(state.func_177230_c());
        if (entry != null && entry.testPredicates(state)) {
            return LazyOptional.of(entry::getLogic);
        }
        return LazyOptional.empty();
    }

    @Override
    public void registerBlockExchanger(Block block, double temperature, double thermalResistance) {
        BlockHeatProperties.getInstance().register(block.getRegistryName(), new BlockHeatProperties.CustomHeatEntry(block, (int)temperature, thermalResistance));
    }

    @Override
    public void registerHeatBehaviour(ResourceLocation id, Supplier<? extends HeatBehaviour<?>> heatBehaviour) {
        HeatBehaviourManager.getInstance().registerBehaviour(id, heatBehaviour);
    }

    @Override
    public IHeatExchangerLogic makeHeatExchangerLogic() {
        return new HeatExchangerLogicTicking();
    }
}

