/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Arrays;
import java.util.HashSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class TemperatureData
implements INBTSerializable<CompoundNBT> {
    private final Double[] temp = new Double[7];
    private boolean isMultisided = true;

    public static TemperatureData fromNBT(CompoundNBT nbt) {
        TemperatureData data = new TemperatureData();
        data.deserializeNBT(nbt);
        return data;
    }

    private TemperatureData() {
    }

    public TemperatureData(ICapabilityProvider provider) {
        Direction face2;
        boolean done;
        Arrays.fill((Object[])this.temp, null);
        HashSet heatExchangers = new HashSet();
        Direction[] directionArray = Direction.field_199792_n;
        int n = directionArray.length;
        for (int i = 0; i < n && !(done = provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, face2 = directionArray[i]).map(h -> {
            if (heatExchangers.contains(h)) {
                this.isMultisided = false;
                return true;
            }
            heatExchangers.add(h);
            return false;
        }).orElse(false).booleanValue()); ++i) {
        }
        if (this.isMultisided) {
            for (Direction face2 : Direction.field_199792_n) {
                provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, face2).ifPresent(h -> {
                    this.temp[face.ordinal()] = h.getTemperature();
                });
            }
        } else {
            provider.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).ifPresent(h -> {
                this.temp[6] = h.getTemperature();
            });
        }
    }

    public boolean isMultisided() {
        return this.isMultisided;
    }

    public double getTemperature(Direction face) {
        return face == null ? this.temp[6] : this.temp[face.ordinal()];
    }

    public boolean hasData(Direction face) {
        return face == null ? this.temp[6] != null : this.temp[face.ordinal()] != null;
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.isMultisided()) {
            ListNBT tagList = new ListNBT();
            for (Direction face : Direction.field_199792_n) {
                if (this.temp[face.ordinal()] == null) continue;
                CompoundNBT heatTag = new CompoundNBT();
                heatTag.func_74774_a("side", (byte)face.ordinal());
                heatTag.func_74768_a("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.func_218657_a("heat", (INBT)tagList);
        } else {
            nbt.func_74768_a("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.isMultisided()) {
            ListNBT tagList = new ListNBT();
            for (Direction face : Direction.field_199792_n) {
                CompoundNBT heatTag = new CompoundNBT();
                heatTag.func_74774_a("side", (byte)face.ordinal());
                heatTag.func_74768_a("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.func_218657_a("heat", (INBT)tagList);
        } else {
            nbt.func_74768_a("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("heat")) {
            this.isMultisided = true;
            ListNBT tagList = nbt.func_150295_c("heat", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT heatTag = tagList.func_150305_b(i);
                this.temp[heatTag.func_74771_c((String)"side")] = heatTag.func_74762_e("temp");
            }
        } else {
            this.isMultisided = false;
            this.temp[6] = nbt.func_74762_e("temp");
        }
    }
}

