/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemGunAmmo
extends Item
implements ColorHandlers.ITintableItem {
    public ItemGunAmmo() {
        super(ModItems.defaultProps().func_200917_a(1).setNoRepair().func_200915_b(1000));
    }

    public int getMaxDamage(ItemStack stack) {
        return PNCConfig.Common.Minigun.standardAmmoCartridgeSize;
    }

    public float getRangeMultiplier(ItemStack ammoStack) {
        return 1.0f;
    }

    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        return 1.0f;
    }

    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract int getAmmoColor(ItemStack var1);

    public int getAmmoCost(ItemStack ammoStack) {
        return 1;
    }

    protected DamageSource getDamageSource(Minigun minigun) {
        return DamageSource.func_76365_a((PlayerEntity)minigun.getPlayer());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> infoList, ITooltipFlag extraInfo) {
        infoList.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.ammoRemaining", stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()));
        super.func_77624_a(stack, world, infoList, extraInfo);
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return tintIndex == 1 ? this.getAmmoColor(stack) : -1;
    }

    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        int times = 1;
        int nSpeed = minigun.getUpgrades(EnumUpgrade.SPEED);
        for (int i = 0; i < nSpeed; ++i) {
            if (minigun.getWorld().field_73012_v.nextInt(100) >= 20) continue;
            ++times;
        }
        double dmgMult = this.getDamageMultiplier(target, ammo);
        if (dmgMult > 0.0) {
            if (target instanceof LivingEntity || target instanceof EnderCrystalEntity) {
                target.func_70097_a(this.getDamageSource(minigun), (float)(PNCConfig.Common.Minigun.baseDamage * dmgMult * (double)times));
            } else if (target instanceof ShulkerBulletEntity || target instanceof DamagingProjectileEntity) {
                target.func_70106_y();
            }
        }
        return times;
    }

    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockRayTraceResult brtr) {
        if (PNCConfig.Common.Minigun.blockHitParticles) {
            World w = minigun.getPlayer().field_70170_p;
            BlockState state = w.func_180495_p(brtr.func_216350_a());
            Direction face = brtr.func_216354_b();
            Vector3d hitVec = brtr.func_216347_e();
            BlockParticleData data = new BlockParticleData(ParticleTypes.field_197611_d, state);
            ((ServerWorld)w).func_195598_a((IParticleData)data, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 10, (double)face.func_82601_c() * 0.2, (double)face.func_96559_d() * 0.2, (double)face.func_82599_e() * 0.2, 0.05);
        }
        return 1;
    }
}

